% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WriteBinaryDosage.R
\name{getaaf}
\alias{getaaf}
\title{Calculate alternate allele frequency}
\usage{
getaaf(dosage, p0, p1, p2)
}
\arguments{
\item{dosage}{Dosage values}

\item{p0}{Pr(g=0) - unused}

\item{p1}{Pr(g=1) - unused}

\item{p2}{Pr(g=2) - unused}
}
\value{
Alternate allele frequency
}
\description{
Routine to calculate the alternate allele frequency given the dosages.
Missing values for dosage ignored. This function is used internally and
is exported for use in examples.
}
\examples{
# Get information about binary dosage file
bdfile <- system.file("extdata", "vcf1a.bdose", package = "BinaryDosage")
bdinfo <- getbdinfo(bdfiles = bdfile)
snp1 <- getsnp(bdinfo = bdinfo, 1)
aaf <- getaaf(snp1$dosage)
}
