% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdblockmult_sparse}
\alias{bdblockmult_sparse}
\title{Block matrix multiplication with Delayed Array Object}
\usage{
bdblockmult_sparse(A, B, paral = NULL, threads = NULL)
}
\arguments{
\item{A}{a sparse double matrix.}

\item{B}{a sparse double matrix.}

\item{paral, }{(optional, default = TRUE) if paral = TRUE performs parallel computation else performs seria computation}

\item{threads}{(optional) only if paral = true, number of concurrent threads in parallelization if threads is null then threads =  maximum number of threads available}
}
\value{
Sparse matrix with results
}
\description{
This function performs a block matrix-matrix multiplication with numeric matrix or Delayed Arrays
}
\examples{

library(Matrix)
library(BigDataStatMeth)

k <- 1e3
set.seed(1)
x_sparse <- sparseMatrix(
    i = sample(x = k, size = k),
    j = sample(x = k, size = k),
    x = rnorm(n = k)
)
set.seed(2)
y_sparse <- sparseMatrix(
    i = sample(x = k, size = k),
    j = sample(x = k, size = k),
    x = rnorm(n = k)
)

d <- bdblockmult_sparse(x_sparse, y_sparse)

}
