% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_bw_p.R
\name{step_bw_p}
\alias{step_bw_p}
\title{Automatized stepwise backward for regression models (with forced terms)}
\usage{
step_bw_p(
  reg_model,
  s_lower = "~1",
  s_upper = "all",
  trace = TRUE,
  steps = NULL,
  p_threshold = 0.05,
  data = NULL,
  forced = NULL,
  ...
)
}
\arguments{
\item{reg_model}{Regression model. Must be a glm or lm object}

\item{s_lower}{Lower step. Names of the variables to be included at the lower step. Default is "~1" (intercept only)}

\item{s_upper}{Upper step. Names of the variables to be included at the upper step. Default is "all" (all predictors)}

\item{trace}{Logical. Whether to print each step to the console. Default is TRUE.}

\item{steps}{Maximum number of elimination steps. If NULL, set to number of predictors.}

\item{p_threshold}{P-value threshold for elimination. Default is 0.05.}

\item{data}{Data frame for stepwise. If NULL, extracted from reg_model.}

\item{forced}{Character vector of predictor names to always keep. Default NULL.}

\item{...}{Additional arguments passed to car::Anova().}
}
\value{
An object of class "step_bw" containing the final model and a data.frame of steps.
}
\description{
Automatized stepwise backward for regression models (with forced terms)
}
\examples{
data(mtcars)
# Fit a linear model
regression_model <- lm(cyl ~ ., data = mtcars)
# Perform backward stepwise, forcing "wt" and "hp" to remain
stepwise <- step_bw_p(
  regression_model,
  forced = c("wt", "hp"),
  trace = FALSE
)
# Extract final model and view summary
final_model <- stepwise$final_model
summary(final_model)

}
\references{
Efroymson MA. Multiple regression analysis. In: Ralston A, Wilf HS, editors. Mathematical methods for digital computers. New York: Wiley; 1960.
}
