% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_Bayes.R
\name{sim_lvm}
\alias{sim_lvm}
\title{Simulate rank data from latent variable model}
\usage{
sim_lvm(G, S, n_p1, rho, p_p1, p_p2, lambda, n_T)
}
\arguments{
\item{G}{total number of genes involved in all of the studies.}

\item{S}{number of studies (ranked lists) to be aggregated.}

\item{n_p1}{number of studies belong to platform 1.}

\item{rho}{correlation between local importance (w) and global importance (mu) for each study, which determines the total variance of w.}

\item{p_p1, p_p2}{percentage of total variance of w contributed by platform variance from platform 1 and platform 2 respectively for the study with the lowest total variance.}

\item{lambda}{inclusion rate for each study.}

\item{n_T}{vector of length \code{S} that contains number of top ranked items in each study.}
}
\description{
Simulate rank data from latent variable model
}
\examples{
set.seed(1234)
sim_lvm(G=25, S=6, n_p1=3, rho=runif(6,min=0.3,max=0.9), p_p1=0.6, p_p2=0.8, 
        lambda=runif(6,min=0.6,max=0.8), n_T=sample(c(5,10,15),6,replace=TRUE))
}
