% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performanceassess.R
\name{modelp}
\alias{modelp}
\title{Estimating a graph corresponding to a posterior probability threshold}
\usage{
modelp(MCMCchain, p, pdag = FALSE, burnin = 0.2)
}
\arguments{
\item{MCMCchain}{object of class \code{partitionMCMC} or \code{orderMCMC}, representing the output of structure sampling function \code{\link{partitionMCMC}} or \code{\link{orderMCMC}} (the latter when parameter \code{chainout}=TRUE;}

\item{p}{threshold such that only edges with a higher posterior probability will be retained in the directed graph summarising the sample of DAGs}

\item{pdag}{logical, if TRUE (FALSE by default) all DAGs in the MCMCchain are first converted to equivalence class (CPDAG) before the averaging}

\item{burnin}{number between \code{0} and \code{1}, indicates the percentage of the samples which will be  the discarded as `burn-in' of the MCMC chain; the rest  of the samples will be used to calculate the posterior probabilities; 0.2 by default}
}
\value{
a square matrix with dimensions equal to the number of variables representing the adjacency matrix of the directed graph summarising the sample of DAGs
}
\description{
This function constructs a directed graph (not necessarily acyclic) including all edges with a posterior probability above a certain threshold.  The posterior probability is evaluated as the Monte Carlo estimate from a sample of DAGs obtained via an MCMC scheme.
}
\examples{
Bostonscore<-scoreparameters("bge", Boston)
\dontrun{
orderfit<-orderMCMC(Bostonscore, MAP=FALSE, iterations=25000, chainout=TRUE)
hdag<-modelp(orderfit, p=0.9)
}
}
\author{
Polina Suter
}
