% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{MaxBC}
\alias{MaxBC}
\title{Finding Maximum Size Biclusters}
\usage{
MaxBC(result, top = 1)
}
\arguments{
\item{result}{A \code{Biclust} result. (e.g. The return object from \code{bibit} or \code{bibit2})}

\item{top}{The number of top row/col/size dimension which are searched for. (e.g. default \code{top=1} gives only the maximum)}
}
\value{
A list containing:
\itemize{
\item \code{$row}: A matrix containing in the columns the Biclusters which had maximum rows, and in the rows the Row Dimension, Column Dimension and Size.
\item \code{$column}: A matrix containing in the columns the Biclusters which had maximum columns, and in the rows the Row Dimension, Column Dimension and Size.
\item \code{$size}: A matrix containing in the columns the Biclusters which had maximum size, and in the rows the Row Dimension, Column Dimension and Size.
}
}
\description{
Simple function which scans a \code{Biclust} result and returns which biclusters have maximum row, column or size (row*column).
}
\examples{
\dontrun{
data <- matrix(sample(c(0,1),100*100,replace=TRUE,prob=c(0.9,0.1)),nrow=100,ncol=100)
data[1:10,1:10] <- 1 # BC1
data[11:20,11:20] <- 1 # BC2
data[21:30,21:30] <- 1 # BC3
data <- data[sample(1:nrow(data),nrow(data)),sample(1:ncol(data),ncol(data))]
result <- bibit(data,minr=2,minc=2)

MaxBC(result)

}
}
\author{
Ewoud De Troyer
}

