% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustPL.R
\name{adjustPL}
\alias{adjustPL}
\title{Adjustment of pseudolikelihood function}
\usage{
adjustPL(formula, aux.iters = 3000, noisy.nsim = 50, noisy.thin = 50,
  ladder = 50, ...)
}
\arguments{
\item{formula}{formula; an \code{\link[ergm]{ergm}} formula object,
of the form  <network> ~ <model terms>
where <network> is a \code{\link[network]{network}} object
and <model terms> are \code{ergm-terms}.}

\item{aux.iters}{count; Number of proposals before any MCMC sampling is done. See \code{\link[ergm]{control.simulate.formula}}.}

\item{noisy.nsim}{count; Number of TNT draws. See \code{\link[ergm]{control.simulate.formula}}.}

\item{noisy.thin}{count; Number of proposals between sampled statistics. See \code{\link[ergm]{control.simulate.formula}}.}

\item{ladder}{count; Length of temperature ladder (>=3).}

\item{...}{Additional arguments, to be passed to the ergm function. See \code{\link[ergm]{ergm}}.}
}
\description{
Function to estimate the transformation parameters for
adjusting the pseudolikelihood function.
}
\references{
Bouranis, L., Friel, N., and Maire, F. (2017). Bayesian model selection for exponential random graph models via
adjusted pseudolikelihoods. \url{https://arxiv.org/abs/1706.06344}
}
