% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFlagSummary.R
\name{plotFlagSummary}
\alias{plotFlagSummary}
\title{Generate a plot summarising flagged data}
\usage{
plotFlagSummary(
  data = NULL,
  flagColours = c("#127852", "#A7002D", "#BDBABB"),
  fileName = NULL,
  outPath = OutPath_Figures,
  width = 15,
  height = 9,
  units = "in",
  dpi = 300,
  bg = "white",
  device = "pdf",
  speciesName = NULL,
  saveFiltered = FALSE,
  filterColumn = FALSE,
  nameColumn = NULL,
  plotMap = FALSE,
  mapAlpha = 0.5,
  saveTable = FALSE,
  jitterValue = NULL,
  returnPlot = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame or tibble. Occurrence records as input.}

\item{flagColours}{A character vector. Colours in order of pass (TRUE), fail (FALSE), and NA.
Default = c("#127852", "#A7002D", "#BDBABB").}

\item{fileName}{Character. The name of the file to be saved, ending in ".pdf".
If saving as a different file type, change file type suffix - See \code{device}.}

\item{outPath}{A character path. The path to the directory in which the figure will be saved.
Default = OutPath_Figures.}

\item{width}{Numeric. The width of the output figure in user-defined units Default = 15.}

\item{height}{Numeric. The height of the output figure in user-defined units Default = 9.}

\item{units}{Character. The units for the figure width and height passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}
("in", "cm", "mm", or "px"). Default = "in".}

\item{dpi}{Numeric. Passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}. Plot resolution. Also accepts a string input: "retina" (320), "print" (300), or
"screen" (72). Applies only to raster output types. Default = 300.}

\item{bg}{Character. Passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}. Background colour. If NULL, uses the plot.background fill value from the plot theme.
Default = "white."}

\item{device}{Character. Passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}. Device to use. Can either be a device function (e.g. png), or one of "eps", "ps", "tex" (pictex), "pdf", "jpeg", "tiff", "png", "bmp", "svg" or "wmf" (windows only).
Default = "pdf". If not using default, change file name suffix in fileName argument.}

\item{speciesName}{Optional. Character. A species name, as it occurs in the user-input nameColumn.
If provided, the data will be filtered to this species for the plot.}

\item{saveFiltered}{Optional. Logical. If TRUE, the filtered data will be saved to the computer
as a .csv file.}

\item{filterColumn}{Optional. The flag column to display on the map. Default = .summary.}

\item{nameColumn}{Optional. Character. If speciesName is not NULL, enter the column to look
for the species in. A User might realise that, combined with speciesName, figures can be made for
a variety of factors.}

\item{plotMap}{Logical. If TRUE, the function will produce a point map. Tested for use with one
species at a time; i.e., with speciesName is not NULL.}

\item{mapAlpha}{Optional. Numeric. The opacity for the points on the map.}

\item{saveTable}{Optional. Logical. If TRUE, the function will save the data used to produce the
compound bar plot.}

\item{jitterValue}{Optional. Numeric. The value to jitter points by in the map in decimal degrees.}

\item{returnPlot}{Logical. If TRUE, return the plot to the environment. Default = FALSE.}

\item{...}{Optional. Extra variables to be fed into \code{\link[forcats:fct_recode]{forcats::fct_recode()}} to change names on plot.
For example... 'B. Mont.' = "BMont", 'B. Minkley' = "BMin", Ecd = "Ecd", Gaiarsa = "Gai"}
}
\value{
Exports a compound bar plot that summarises all flag columns. Optionally can also return
a point map for a particular species in tandem with the summary plot.
}
\description{
Creates a compound bar plot that shows the proportion of records that pass or fail each flag (rows)
and for each data source (columns). The function can also optionally return a point map for
a user-specified species when plotMap = TRUE. This function requires that your dataset has been
run through some filtering functions - so that is can display logical columns starting with
".".
}
\examples{
# import data
data(beesFlagged)
OutPath_Figures <- tempdir()
 # Visualise all flags for each dataSource (simplified to the text before the first underscore)
plotFlagSummary(
  data = beesFlagged,
  # Colours in order of pass (TRUE), fail (FALSE), and NA
  flagColours = c("#127852", "#A7002D", "#BDBABB"),
  fileName = paste0("FlagsPlot_TEST_", Sys.Date(),".pdf"),
  outPath = OutPath_Figures,
  width = 15, height = 9,
  # OPTIONAL:
  #\   #  # Filter to species
  #\   speciesName = "Holcopasites heliopsis",
  #\   # column to look in
  #\   nameColumn = "species",
  #\   # Save the filtered data
  #\   saveFiltered = TRUE,
  #\   # Filter column to display on map
  #\   filterColumn = ".summary",
  #\   plotMap = TRUE,
  #\   # amount to jitter points if desired, e.g. 0.25 or NULL
  #\   jitterValue = NULL,
  #\   # Map opacity value for points between 0 and 1
  #\   mapAlpha = 1,
  # Extra variables can be fed into forcats::fct_recode() to change names on plot
  GBIF = "GBIF", SCAN = "SCAN", iDigBio = "iDigBio", USGS = "USGS", ALA = "ALA", 
  ASP = "ASP", CAES = "CAES", 'B. Mont.' = "BMont", 'B. Minkley' = "BMin", Ecd = "Ecd",
  Gaiarsa = "Gai", EPEL = "EPEL"
)



}
