% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.BchronRSLRun.R
\name{summary.BchronRSLRun}
\alias{summary.BchronRSLRun}
\title{Summarise a BchronRSL run}
\usage{
\method{summary}{BchronRSLRun}(
  object,
  type = c("parameters", "RSL", "rate", "accel"),
  age_grid = NULL,
  ...
)
}
\arguments{
\item{object}{The output from a run of \code{\link{BchronRSL}}}

\item{type}{One of \code{parameters}, \code{RSL}, \code{rate}, or \code{accel}. If \code{parameters}, provides posterior credibility intervals of the regression coefficients. If \code{RSL} provides predicted RSL values. If \code{rate}, provides rate estimates. If \code{accel} provides acceleration estimates.}

\item{age_grid}{An optional age grid for computing RSL, rate, or acceleration estimates. If not provided uses the age range of the Bchronology run}

\item{...}{Other arguments to functions (not currently implemented)}
}
\value{
A summary of the BchronRSL run, including posterior medians and credible intervals for the regression coefficients, RSL estimates, rate estimates, and acceleration estimates.
}
\description{
Summarise a \code{\link{BchronRSL}} run
}
\seealso{
\code{\link{BchronCalibrate}}, \code{\link{Bchronology}}, \code{\link{BchronRSL}}, \code{\link{BchronDensity}}, \code{\link{BchronDensityFast}}
}
