% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTimeSeries.R
\name{plotTimeSeriesResults}
\alias{plotTimeSeriesResults}
\title{Creates a time series plot typical for an MCMC / SMC fit}
\usage{
plotTimeSeriesResults(sampler, model, observed, error = NULL,
  plotResiduals = T, start = 1)
}
\arguments{
\item{sampler}{Either a) a matrix b) an MCMC object (list or not), or c) an SMC object}

\item{model}{function that calculates model predictions for a given parameter vector}

\item{observed}{observed values}

\item{error}{function with signature f(mean, par) that generates error expectations from mean model predictions. Par is a vector from the matrix with the parameter samples (full length). f needs to know which of these parameters are parameters of the error function}

\item{plotResiduals}{logical determining whether residuals should be plotted}

\item{start}{numeric start value for the plot (see \code{\link{getSample}})}
}
\description{
Creates a time series plot typical for an MCMC / SMC fit
}
\author{
Florian Hartig
}
