% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFROC.R
\name{AFROC}
\alias{AFROC}
\title{AFROC curve}
\usage{
AFROC(x, a = 0.14, b = 0.19, x.coordinate.also = FALSE)
}
\arguments{
\item{x}{A real number which moves in the domain  of FROC curve}

\item{a, b}{One of the parameter of model which characterize AFROC curve}

\item{x.coordinate.also}{Logical, whether a vector of \code{1-exp(-x)}
is included in a return value.}
}
\value{
if \code{x.coordinate.also =TRUE}, then
A list, contains two vectors of x,y cooridinates
 for drawing curves.
 if \code{x.coordinate.also =FALSE}, then
 return is  a vector, consisting of y coodinate only,
  (x coodinates is omitted.)
}
\description{
An AFROC curve is a plane curve
 characterized by two real numbers denoted by \eqn{a,b}.
 In the following, \eqn{\Phi()} denotes the cumulative distribution function
 on the standard Gaussian disribution.


The so-called \emph{AFROC} curve is defined by


\deqn{  (\xi(t),\eta(t) ) =(1-e^{-t}, \Phi( b\Phi^{-1}(\exp(-t) )- a   ) )}

for all \eqn{t >0}.


By specifying  two real numbers \eqn{a} and \eqn{b}, we can plot  an AFROC curve.



The are under the AFROC curve, or  breafly AUC,  is calculated as follows, whic
are used to evaluate how  physicians detect lesions in radiographs.

\deqn{  AUC = \frac{ a }{ \sqrt{1+  b^2} }. }
}
\examples{

   x <- stats::runif(1000,0.001,100)
   a <-  AFROC(x,x.coordinate.also=TRUE)

   plot(a$x,a$y)

}
