% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_square_goodness_of_fit.R
\name{chi_square_at_replicated_data_and_MCMC_samples_MRMC}
\alias{chi_square_at_replicated_data_and_MCMC_samples_MRMC}
\title{chi square at replicated data drawn (only one time) from model with each MCMC samples.}
\usage{
chi_square_at_replicated_data_and_MCMC_samples_MRMC(StanS4class,
  summary = TRUE, seed = NA, serial.number = NA)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{\link[rstan]{stanfit}}. This \R object can be passed to the \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}

\item{seed}{This is  used only in programming phase.
If seed is passed, then, in procedure indicator the seed is printed.
This parameter is only for package development.}

\item{serial.number}{An positive integer
or Character. This is for programming perspective.
The author use this to print the serial
 numbre of validation. This will be used
 in the validation function.}
}
\value{
From any given posterior MCMC samples  \eqn{\theta_1,\theta_2,...,\theta_i,....,\theta_n} (provided by stanfitExtended object),
it calculates a return value as a vector of the form \eqn{\chi(y_i|\theta_i),i=1,2,....},
 where each dataset \eqn{y_i} is drawn
 from a likelihood \eqn{likelihood(.|\theta_i)},
 namely,

   \deqn{y_i ~ likelihood(.| \theta_i).}

The return value also retains \eqn{y_i}.



Revised 2019 Dec. 2
}
\description{
In order to pass this result to  posterior predictive p value calculator.
}
\details{
For a given dataset \eqn{D_0},
let \eqn{\pi(|D_0)} be a posterior
of the given data \eqn{D_0}, then we can draw poterior samples.


   \deqn{\theta_1 ~ \pi(.|  D_0),}
   \deqn{\theta_2 ~ \pi(.|  D_0),}
   \deqn{\theta_3 ~ \pi(.|  D_0),}
   \deqn{....,}
   \deqn{\theta_n ~ \pi(.|  D_0).}



We let \eqn{f(|\theta)}  be a likelihood function.
Then we can draw samples in \strong{only one time} from
the collection of likelihoods  \eqn{likelihood(\\theta_1),likelihood(\\theta_2),...,likelihood(\\theta_n)}.



   \deqn{y_1 ~ likelihood(.| \theta_1),}
   \deqn{y_2 ~ likelihood(.| \theta_2),}
   \deqn{y_3 ~ likelihood(.| \theta_3),}
   \deqn{....,}
   \deqn{y_n ~ likelihood(.| \theta_n).}





   Altogether, using these pair of samples \eqn{(y_i, \theta_i), i= 1,2,...,n} we calculates the
   \strong{return value} of this function. That is,


   \deqn{\chi(y_1|\theta_1),}
   \deqn{\chi(y_2|\theta_2),}
   \deqn{\chi(y_3|\theta_3),}
   \deqn{....,}
   \deqn{\chi(y_n|\theta_n).}

   \emph{ \strong{This is contained in a return value}},

   so the return value is a vector of length
   is the number of MCMC iterations
    except the burn-in period.





\emph{ \strong{ Application of this return value: calculate the so-called \emph{Posterior Predictive P value.} } }

In other functions,
the author use this function with many seeds, namely,
chaning seed, we can obtain



\deqn{y_1^1,y_1^2,y_1^3,...,y_1^j,....,y_1^J ~ likelihood ( . |\theta_1), }
\deqn{y_2^1,y_2^2,y_2^3,...,y_2^j,....,y_2^J ~ likelihood ( . |\theta_2),}
\deqn{y_3^1,y_3^2,y_3^3,...,y_3^j,....,y_3^J ~ likelihood ( .|\theta_3),}
\deqn{...,}
\deqn{y_i^1,y_i^2,y_i^3,...,y_i^j,....,y_i^J ~ likelihood ( . |\theta_i),}
\deqn{...,}
\deqn{y_I^1,y_I^2,y_I^3,...,y_I^j,....,y_I^J ~ likelihood ( . |\theta_I),}



And thus, we will obatin

\deqn{\chi(1|\theta_1),\chi(1|\theta_2),\chi(1|\theta_3),...,\chi(1|\theta_j),....,\chi(1|\theta_J),   }
\deqn{\chi(2|\theta_1),\chi(2|\theta_2),\chi(2|\theta_3),...,\chi(2|\theta_j),....,\chi(2|\theta_J),  }
\deqn{\chi(3|\theta_1),\chi(3|\theta_2),\chi(3|\theta_3),...,\chi(3|\theta_j),....,\chi(3|\theta_J),   }
\deqn{...,}
\deqn{\chi(i|\theta_1),\chi(i|\theta_2),\chi(i|\theta_3),...,\chi(i|\theta_j),....,\chi(i|\theta_J),  }
\deqn{...,}
\deqn{\chi(I|\theta_1),\chi(I|\theta_2),\chi(I|\theta_3),...,\chi(I|\theta_j),....,\chi(I|\theta_J),  }

whih are used when we calculate the so-called \emph{Posterior Predictive P value.}


Revised 2019 Sept. 8
Revised 2019 Dec. 2
}
\examples{


\donttest{

  fit <- fit_Bayesian_FROC( ite  = 1111,  dataList = ddd )
 a <- chi_square_at_replicated_data_and_MCMC_samples_MRMC(fit)

}


}
