% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_FPF_and_TPF_from_a_dataset.R
\name{plot_FPF_and_TPF_from_a_dataset}
\alias{plot_FPF_and_TPF_from_a_dataset}
\title{Plot FPF and TPF from MRMC data}
\usage{
plot_FPF_and_TPF_from_a_dataset(dataList, ModifiedPoisson = FALSE)
}
\arguments{
\item{dataList}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \pkg{rstan}. This is a variable in the function \code{rstan::sampling()} in which it is named \code{data}.



 For the single reader and a single modality data, the \code{dataList} is the following forms:

\code{ dataList.Example <- list(       }

\code{            h = c(41,22,14,8,1),   }

\code{            f = c(1,2,5,11,13),    }

\code{            NL = 124,     }

\code{            NI = 63,    }

\code{            C = 5)         }

And using this object \code{dataList.Example}, we can apply \code{fit_Bayesian_FROC()} such as \code{fit_Bayesian_FROC(dataList.Example)}.






To make this \R object \code{dataList}, this package provides three functions:
please use one of the following codes to obtain an \R object representing FROC data:


\describe{
\item{  \code{ \link{convertFromJafroc}()}           }{ If  data is a           \emph{\strong{JAFROC xlsx}} formulation.}
\item{  \code{ \link{dataset_creator_new_version}()} }{ Enter TP and FP data    \emph{\strong{by table   }}.            }
\item{  \code{ \link{create_dataset}()}              }{ Enter TP and FP data by \emph{\strong{interactive}} manner.     }
}

This package includes FROC datasets.
Before running the function, we can confirm dataset is correctly formulated by using the function \strong{\code{ \link{viewdata}}}.


----------------------------------------------------------------------------------------


  \strong{A Single reader and a single modality (SRSC) case.}


----------------------------------------------------------------------------------------

In a single reader and a single modality case (srsc), it should be a list which includes  \code{f, h, NL, NI, C}.
This list contains the following numeric vectors \code{f, h} and numeric \code{NL, NI, C} :
\describe{
\item{ \code{f}  }{Non-negative integer vector  specifying  number of False Alarms   associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{h}  }{Non-negative integer vector  specifying  number  of Hits  associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{NL} }{A positive integer, representing  Number of Lesions.}
\item{ \code{NI} }{A positive integer, representing  Number of Images. }
\item{ \code{C}  }{A positive integer, representing  Number of Confidence level. }
}




The detail of these dataset, see the datasets  endowed with this package.
'Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
Note that confidence level vector \code{c } should not be specified. If specified, will be ignored , since it is created by \code{  c <-c(rep(C:1))} in the program and do not refer from user input data, where \code{C} is the highest number of confidence levels.
So, you should write down your hits and false alarms vector so that it is compatible with this automatically created \code{c} vector.


\strong{\emph{ data Format:}}

 \emph{            A single reader and a single modality case   }

------------------------------------------------------------------------------------------------------
\tabular{rccc}{
\code{NI=63,NL=124}   \tab \strong{ confidence level } \tab \strong{ No. of false alarms} \tab \strong{No. of hits}  \cr
 In R console ->      \tab \code{ c} \tab   \code{f }  \tab   \code{h}  \cr
  -----------------------\tab ----------------------- \tab ----------------------------- \tab ------------- \cr
\emph{definitely} present  \tab  \code{c[1] = }5 \tab \code{f[1] = }\eqn{F_5} = 1 \tab  \code{h[1] = }\eqn{H_5} = 41 \cr
 \emph{probably} present   \tab  \code{c[2] = }4 \tab \code{f[2] = }\eqn{F_4} = 2 \tab  \code{h[2] = }\eqn{H_4} = 22 \cr
 equivocal                 \tab  \code{c[3] = }3 \tab \code{f[3] = }\eqn{F_3} = 5 \tab  \code{h[3] = }\eqn{H_3} = 14  \cr
 subtle                    \tab  \code{c[4] = }2 \tab \code{f[4] = }\eqn{F_2} = 11 \tab \code{h[4] = }\eqn{H_2} = 8  \cr
 \emph{very} subtle        \tab  \code{c[5] = }1 \tab \code{f[5] = }\eqn{F_1} = 13 \tab \code{h[5] = }\eqn{H_1} = 1  \cr
 }

---------------------------------------------------------------------------------------------------



*  \emph{false alarms} = False Positives = FP

*  \emph{hits} = True Positives = TP

Note that  in FROC data, all confidence level means \emph{present} (\emph{diseased, lesion}) case only, no confidence level indicating absent.. Since each reader marks their suspicious location only and it generate the hits and false alarms, \emph{thus} his confidence level representing that lesion is \emph{present}.
In the absent case, reader dose not mark any locations and hence, the absent confidence level does not relate this dataset. So, if reader think it is no lesion, then in such case confidence level is not needed.


Note that the first column of confidence level vector \code{c } should not be specified. If specified, will be ignored , since it is created by \code{  c <-c(rep(C:1))} automatically in the program and do not refer from user input data even if it is specified explicitly, where \code{C} is the highest number of confidence levels.
So you should check the compatibility of your data and the program's generating new confidence  level vector by
a table which can be displayed by the function \code{\link{viewdata}()}.









---------------------------------------------------------------------------------------

  \strong{Multiple readers and multiple modalities case, i.e., MRMC case}


---------------------------------------------------------------------------------------


For  multiple readers and multiple modalities case, i.e., MRMC case,
to apply the function \code{fit_Bayesian_FROC()}, an \R list object representing FROC data
must have components \code{m,q,c,h,f,NL,C,M,Q}:
\describe{
\item{ \code{C }  }{A positive integer, representing  the \emph{\strong{highest}} number of confidence level, this is a scalar.}
\item{ \code{M }  }{A positive integer vector, representing  the number of \emph{\strong{modalities}}.  }
\item{ \code{Q }  }{A positive integer, representing  the number of \emph{\strong{readers}}. }
\item{ \code{c }  }{A vector of positive integers,  representing  the \emph{\strong{confidence level}}. This vector must be made by \code{rep(rep(C:1), M*Q)} }
\item{ \code{m }  }{A vector of positive integers,  representing  the \emph{\strong{modality}} ID vector. }
\item{ \code{q }  }{A vector of positive integers,  representing  the \emph{\strong{reader}} ID vector.}
\item{ \code{h }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{hits}} vector.}
\item{ \code{f }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{false alarm}} vector.}
\item{ \code{NL }  }{A positive integer, representing  the Total number of \emph{\strong{lesions}} for all images, this is a scalar.}
}



The detail of these dataset, please see the example datasets ( the section \strong{See Also} in the below) in this package.



Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
its each confidence level vector also created in the program by \code{C}. So, to confirm
your false positives and hits are correctly correspond
to confidence levels,
you should confirm the orders by the function \code{\link{viewdata}()}.


\strong{\emph{ Example data: }}

 \emph{ Multiple readers and multiple modalities case, i.e., MRMC case }




---------------------------------------------------------------------------------------------------
\tabular{ccccc}{
 \strong{ Reader ID} \tab   \strong{Mortality }  \tab  \strong{ Confidence levels} \tab   \strong{No. of false alarms} \tab   \strong{No. of hits}.\cr
  \code{q} \tab  \code{ m}  \tab   \code{c} \tab  \code{ f} \tab \code{ h}\cr
  -------- \tab ------------- \tab ------------------------ \tab  ------------------- \tab ----------------\cr
  1 \tab 1 \tab 5 \tab  1\tab 15\cr
  1 \tab 2 \tab 4  \tab 3\tab 14\cr
  1 \tab 3 \tab 3  \tab 5\tab 5\cr
  1 \tab 1 \tab 2  \tab 5\tab 3\cr
  1 \tab 2 \tab 1  \tab 9\tab 4\cr
  1 \tab 3 \tab 5  \tab 1\tab 14\cr
  1 \tab 1 \tab 4  \tab 2\tab 13\cr
  1 \tab 2 \tab 3  \tab 2\tab 5\cr
  1 \tab 3 \tab 2 \tab 5\tab 3\cr
  2 \tab 1 \tab 1 \tab  6\tab 4\cr
  2 \tab 2 \tab 5  \tab 1\tab 14\cr
  2 \tab 3 \tab 4  \tab 1\tab 4\cr
  2 \tab 1 \tab 3  \tab 1\tab 1\cr
  2 \tab 2 \tab 2  \tab 2\tab 2\cr
  2 \tab 3 \tab 1  \tab 3\tab 2\cr
  2 \tab 1 \tab 5  \tab 1\tab 13\cr
  2 \tab 2 \tab 4 \tab 2\tab 4\cr
  2 \tab 3 \tab 3  \tab 1\tab 2\cr }
---------------------------------------------------------------------------------------------------




*  \emph{false alarms} = False Positives = FP

*  \emph{hits} = True Positives = TP}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \emph{per lesion},
and model is fitted so that the FROC curve is a expected curve of TPF and FPF \emph{per lesion}.
If \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm is calculated \emph{per image},
and model is fitted so that the FROC curve is a expected curve of TPF and FPF \emph{per image}.
To know detail, see the author's paper in which I explained \emph{per image} and \emph{per lesion}.(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  })

If \code{ModifiedPoisson = TRUE},
 then the \emph{False Positive Fraction (FPF)} is calculated as follows
 (\eqn{f_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_L}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_L}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_L}, }

  \deqn{ \frac{f_4+f_5}{N_L}, }

   \deqn{ \frac{f_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_I}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_I}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_I}, }

  \deqn{ \frac{f_4+f_5}{N_I}, }

   \deqn{ \frac{f_5}{N_I}, }

where \eqn{N_I} is a number of images (trial).


The model is fitted so that the estimated FROC curve is on the FPF per image or per lesion accordingly.

If \code{ModifiedPoisson = TRUE}, then FROC curve means the expected pair of FPF \strong{per lesion} and TPF.

On the other hand, if  \code{ModifiedPoisson = FALSE}, then FROC curve means the expected pair of \strong{FPF per image} and TPF.




So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it uses only per images (trial). Since we can divide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author also developed FROC theory to consider FROC analysis under per signal.
One can see that the FROC curve is rigid with respect to change of a number of images, so, it does not matter whether \code{ModifiedPoisson = TRUE} or \code{FALSE}.

Revised 2019 August 28}
}
\value{
TPF and FPF
}
\description{
From data (srsc or MRMC), empirical FROC is plotted, namely FPF and TPF.
}
\examples{

#======================================================================================
#                                      srsc
#======================================================================================
 # FPF is Per image


                       plot_FPF_and_TPF_from_a_dataset(d)



#======================================================================================
#                                     MRMC
#======================================================================================

 # FPF is Per lesion


                        plot_FPF_and_TPF_from_a_dataset(dd)


}
