% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_dataset_MRMC.R
\docType{data}
\name{dd.orderd}
\alias{dd.orderd}
\title{Multiple Reader and Multiple Modality Data}
\description{
A list, representing FROC data of MRMC. This is same as \code{\link{dataList.Chakra.Web} }.
}
\details{
This data is based on in Chakraborty's JAFROC software
in which example data exists.
 The author have calculated hits and false alarms
 from this Jafroc example data.
 Moreover the author ordered it such that the modality ID  also means
 its observer performance, namely Modality ID = 1 means it has the most high AUC.
}
\section{contents}{

 \tabular{ccccc}{
 \strong{ModalityID } \tab   \strong{ReaderID }  \tab  \strong{ Confidence levels} \tab   \strong{No. of hits} \tab \strong{No. of false alarms} \cr
\code{m} \tab \code{q} \tab \code{c} \tab \code{h} \tab  \code{f}\cr
  -------------- \tab ------------- \tab ------------------------ \tab  ------------------- \tab ----------------\cr

1 \tab 1 \tab 5 \tab 61 \tab  1\cr
1 \tab 1 \tab 4 \tab 19 \tab  4\cr
1 \tab 1 \tab 3 \tab 12 \tab 18\cr
1 \tab 1 \tab 2 \tab  9 \tab 21\cr
1 \tab 1 \tab 1 \tab  3 \tab 23\cr
1 \tab 2 \tab 5 \tab 16 \tab  1\cr
1 \tab 2 \tab 4 \tab 29 \tab  1\cr
1 \tab 2 \tab 3 \tab 34 \tab  0\cr
1 \tab 2 \tab 2 \tab  1 \tab 11\cr
1 \tab 2 \tab 1 \tab  0 \tab 35\cr
1 \tab 3 \tab 5 \tab 52 \tab  6\cr
1 \tab 3 \tab 4 \tab 29 \tab 14\cr
1 \tab 3 \tab 3 \tab 10 \tab 37\cr
1 \tab 3 \tab 2 \tab  4 \tab 36\cr
1 \tab 3 \tab 1 \tab  3 \tab 18\cr
1 \tab 4 \tab 5 \tab 10 \tab  0\cr
1 \tab 4 \tab 4 \tab 16 \tab  2\cr
1 \tab 4 \tab 3 \tab 23 \tab  4\cr
1 \tab 4 \tab 2 \tab 43 \tab 18\cr
1 \tab 4 \tab 1 \tab 15 \tab 25\cr
2 \tab 1 \tab 5 \tab 52 \tab  1\cr
2 \tab 1 \tab 4 \tab 25 \tab  1\cr
2 \tab 1 \tab 3 \tab 13 \tab 21\cr
2 \tab 1 \tab 2 \tab  4 \tab 24\cr
2 \tab 1 \tab 1 \tab  1 \tab 23\cr
2 \tab 2 \tab 5 \tab 27 \tab  1\cr
2 \tab 2 \tab 4 \tab 28 \tab  1\cr
2 \tab 2 \tab 3 \tab 29 \tab  5\cr
2 \tab 2 \tab 2 \tab  1 \tab 30\cr
2 \tab 2 \tab 1 \tab  0 \tab 40\cr
2 \tab 3 \tab 5 \tab 53 \tab  2\cr
2 \tab 3 \tab 4 \tab 29 \tab 19\cr
2 \tab 3 \tab 3 \tab 13 \tab 31\cr
2 \tab 3 \tab 2 \tab  2 \tab 56\cr
2 \tab 3 \tab 1 \tab  4 \tab 42\cr
2 \tab 4 \tab 5 \tab  9 \tab  2\cr
2 \tab 4 \tab 4 \tab 16 \tab  0\cr
2 \tab 4 \tab 3 \tab 22 \tab  2\cr
2 \tab 4 \tab 2 \tab 43 \tab 30\cr
2 \tab 4 \tab 1 \tab 14 \tab 32\cr
3 \tab 1 \tab 5 \tab 50 \tab  0\cr
3 \tab 1 \tab 4 \tab 30 \tab  4\cr
3 \tab 1 \tab 3 \tab 11 \tab 20\cr
3 \tab 1 \tab 2 \tab  5 \tab 29\cr
3 \tab 1 \tab 1 \tab  1 \tab 21\cr
3 \tab 2 \tab 5 \tab 15 \tab  0\cr
3 \tab 2 \tab 4 \tab 29 \tab  0\cr
3 \tab 2 \tab 3 \tab 29 \tab  6\cr
3 \tab 2 \tab 2 \tab  1 \tab 15\cr
3 \tab 2 \tab 1 \tab  0 \tab 22\cr
3 \tab 3 \tab 5 \tab 39 \tab  1\cr
3 \tab 3 \tab 4 \tab 31 \tab 15\cr
3 \tab 3 \tab 3 \tab  8 \tab 18\cr
3 \tab 3 \tab 2 \tab 10 \tab 31\cr
3 \tab 3 \tab 1 \tab  3 \tab 19\cr
3 \tab 4 \tab 5 \tab 10 \tab  1\cr
3 \tab 4 \tab 4 \tab  8 \tab  2\cr
3 \tab 4 \tab 3 \tab 25 \tab  4\cr
3 \tab 4 \tab 2 \tab 45 \tab 16\cr
3 \tab 4 \tab 1 \tab 14 \tab 17\cr
4 \tab 1 \tab 5 \tab 35 \tab  0\cr
4 \tab 1 \tab 4 \tab 29 \tab  2\cr
4 \tab 1 \tab 3 \tab 18 \tab 19\cr
4 \tab 1 \tab 2 \tab  9 \tab 23\cr
4 \tab 1 \tab 1 \tab  0 \tab 18\cr
4 \tab 2 \tab 5 \tab 17 \tab  0\cr
4 \tab 2 \tab 4 \tab 27 \tab  2\cr
4 \tab 2 \tab 3 \tab 24 \tab  6\cr
4 \tab 2 \tab 2 \tab  0 \tab 10\cr
4 \tab 2 \tab 1 \tab  0 \tab 30\cr
4 \tab 3 \tab 5 \tab 34 \tab  2\cr
4 \tab 3 \tab 4 \tab 33 \tab 25\cr
4 \tab 3 \tab 3 \tab  7 \tab 40\cr
4 \tab 3 \tab 2 \tab 13 \tab 29\cr
4 \tab 3 \tab 1 \tab  2 \tab 24\cr
4 \tab 4 \tab 5 \tab 12 \tab  1\cr
4 \tab 4 \tab 4 \tab 16 \tab  1\cr
4 \tab 4 \tab 3 \tab 21 \tab  4\cr
4 \tab 4 \tab 2 \tab 35 \tab 24\cr
4 \tab 4 \tab 1 \tab 15 \tab 32\cr
5 \tab 1 \tab 5 \tab 43 \tab  1\cr
5 \tab 1 \tab 4 \tab 29 \tab  7\cr
5 \tab 1 \tab 3 \tab 11 \tab 13\cr
5 \tab 1 \tab 2 \tab  6 \tab 28\cr
5 \tab 1 \tab 1 \tab  0 \tab 19\cr
5 \tab 2 \tab 5 \tab 18 \tab  0\cr
5 \tab 2 \tab 4 \tab 29 \tab  1\cr
5 \tab 2 \tab 3 \tab 21 \tab  7\cr
5 \tab 2 \tab 2 \tab  0 \tab  7\cr
5 \tab 2 \tab 1 \tab  0 \tab 31\cr
5 \tab 3 \tab 5 \tab 43 \tab  7\cr
5 \tab 3 \tab 4 \tab 29 \tab 15\cr
5 \tab 3 \tab 3 \tab  6 \tab 28\cr
5 \tab 3 \tab 2 \tab  7 \tab 41\cr
5 \tab 3 \tab 1 \tab  1 \tab  9\cr
5 \tab 4 \tab 5 \tab 10 \tab  0\cr
5 \tab 4 \tab 4 \tab 14 \tab  2\cr
5 \tab 4 \tab 3 \tab 19 \tab  5\cr
5 \tab 4 \tab 2 \tab 32 \tab 24\cr
5 \tab 4 \tab 1 \tab 23 \tab 31
}
}

\examples{


    viewdata(BayesianFROC::dd.orderd)








#----------------------------------------------------------------------------------------
#                           Code to make the dataset dd
#----------------------------------------------------------------------------------------


h<-c(
  61,19,12,9,3,16,29,34,1,0,52,29,10,4 ,3,10,16,23,43,15, # modality 4 of dataset dd
  52,25,13,4,1,27,28,29,1,0,53,29,13,2 ,4,9 ,16,22,43,14, # modality 2 of dataset dd
  50,30,11,5,1,15,29,29,1,0,39,31,8 ,10,3,10,8 ,25,45,14, # modality 1 of dataset dd
  35,29,18,9,0,17,27,24,0,0,34,33,7 ,13,2,12,16,21,35,15,  # modality 5 of dataset dd
  43,29,11,6,0,18,29,21,0,0,43,29,6 ,7 ,1,10,14,19,32,23 # modality 3   of dataset dd

)

f <-c(
  1, 4,18,21,23,1,1,0,11,35, 6,14,37,36,18,0,2,4,18,25,# modality 4  of dataset dd
  1 ,1,21,24,23,1,1,5,30,40,2 ,19,31,56,42,2,0,2,30,32,# modality 2 of dataset dd
  0 ,4,20,29,21,0,0,6,15,22,1 ,15,18,31,19,1,2,4,16,17,# modality 1 of dataset dd
  0, 2,19,23,18,0,2,6,10,30, 2,25,40,29,24,1,1,4,24,32,# modality 5 of dataset dd
  1, 7,13,28,19,0,1,7, 7,31, 7,15,28,41,9 ,0,2,5,24,31# modality 3 of dataset dd

)

a   <- m_q_c_vector_from_M_Q_C(5,4,5)

m <- a$m
c <- a$c
q <- a$q

NI<-199
NL <-142
C<-5
M<-5
Q<-4

dd.orderd <- list(
  h=h,
  f=f,
  m=m,
  c=c,
  q=q,
  NI=NI,
  NL=NL,
  M=M,
  Q=Q,
  C=C
)
}
\references{
Example data of Jafroc software
}
\author{
Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
}
