#' @title  Fit the null model
#'@description  Fit the null model, representing the null hypothesis that all modalities are same.
#'@inheritParams fit_srsc
#'@inheritParams fit_Bayesian_FROC
#' @export fit_Null_hypothesis_model_to_
#'@author Issei Tsunoda

fit_Null_hypothesis_model_to_<- function(
  dataList,
  DrawCurve = FALSE,
  PreciseLogLikelihood = FALSE,
  dataList.Name = "",

  summary =TRUE,
  mesh.for.drawing.curve=10000,
  significantLevel = 0.7,
  cha = 1,
  war = floor(ite/5),
  ite = 10000,
  dig = 3,
  see = 1234569
){

  if ( is.null(dataList$m)||is.null(dataList$q)||is.null(dataList$c)) {
    return(message("Dataformat error.  Your data may be not multiple reader and multiple case,
                   but a single reader and a singlr modality case."))
  }


  if(summary==TRUE){ viewdata(dataList )} # I do not know, but this code is the availble only in the last part.

  # war <- 5000 ;ite <- 10000;see <- 1234;dig <- 3;cha <- 4;
  # scr <- "Model_Hiera.stan";
  # source("Data_Hiera.R");

   scr <- system.file("extdata", "null_hier.stan", package="BayesianFROC")



  data <-metadata_to_fit_MRMC(dataList)

  m<-data$m   ;S<-data$S;  NL<-data$NL;c<-data$c;q<-data$q;
  h<-data$h; f<-data$f;
  hh<-data$hh; hhN<-data$hhN;
  ff<-data$ff;ffN<-data$ffN;
  harray<-data$harray;    farray<-data$farray;
  hharray<-data$hharray;    ffarray<-data$ffarray;
  hharrayN<-data$hharrayN;    ffarrayN<-data$ffarrayN;

  C<-as.integer(data$C)
  M<-as.integer(data$M)
  N<-as.integer(data$N)
  Q<-as.integer(data$Q)


  if (summary==FALSE)message("\n* Now, the Hamiltonian Monte Carlo simulation is running...")


  rstan_options(auto_write = TRUE)

  scr <- rstan::stan_model(scr)# add

  # fit  <-  rstan::sampling(
  #                 object= scr, data=data,  verbose=F,
  #                  seed=see, chains=cha, warmup=war, iter=ite
  #                     , control = list(adapt_delta = 0.9999999,
  #                    max_treedepth = 15)
  #,init = initial
  # )
  # initial <- initial_values_specification_for_stan_in_case_of_MRMC(dataList)
  if (summary==FALSE) {


    invisible(utils::capture.output(
      fit  <-  rstan::sampling(
        object= scr, data=data,  verbose=F,
        seed=see, chains=cha, warmup=war, iter=ite
        , control = list(adapt_delta = 0.9999999,
                         max_treedepth = 15)
        # ,init = initial
      )
    ))
  }#if


  if (summary==TRUE) {

    fit  <-  rstan::sampling(
      object= scr, data=data,  verbose=F,
      seed=see, chains=cha, warmup=war, iter=ite
      , control = list(adapt_delta = 0.9999999,
                       max_treedepth = 15)#,init = initial
    )

  }#if


  #   fit  <- stan(file=scr, model_name=scr, data=data, verbose=F,
  #                seed=see, chains=cha, warmup=war,
  #                iter=ite, control = list(adapt_delta = 0.9999999,
  #                                         max_treedepth = 15)
  # )

  # rstan::check_hmc_diagnostics(fit)

  convergence <- ConfirmConvergence(fit)
  if(convergence ==FALSE){message("\n* So, model has no mean, we have to finish a calculation !!\n")
    return(fit)}
  if(convergence ==TRUE){ if(summary==TRUE)         message(crayon::silver( "\n* We do not stop, since model cannot be said not converged.\n"))
  }

  if(summary==TRUE) {
    # message("---------- Useage of the return value-------------------------  \n")
    message(crayon::silver( "\n * Using this return value which is S4 class generated by rstan::stan and another function in this package, you can draw FROC and AFROC curves.   \n"))
    message(crayon::silver( "\n * Using this return value, you can apply functions in the package rstan, e.g., rstan::traceplot().   \n"))
    # message("\n-----------------------------------------  \n")
    # message(" \n--------------------------------------------------  \n")
    if(PreciseLogLikelihood == FALSE  ){
      message(crayon::silver( "\n* WAIC did not caluculated, since log likelihood is not a precise value.\n"))
      # message(" \n--------------------------------------------------  \n")

    }else{
      if(PreciseLogLikelihood == TRUE  ){
        message(crayon::silver( "\n* WAIC was caluculated, since log likelihoodis is a precise value, i.e., the traget += statement are used in the stan file.\n"))
        # message(" \n--------------------------------------------------  \n")
        waic(fit)
      } else{
        print("PreciseLogLikelihood is allowed only two choice; TRUE or FALSE.")
      }}
  }# if summary ==TRUE


  fit.new.class <- methods::as(fit,"stanfitExtended")
  fit.new.class@metadata <-data
  fit.new.class@dataList <-dataList
  fit.new.class@studyDesign <-  "MRMC"
  fit.new.class@PreciseLogLikelihood    <-  PreciseLogLikelihood


  if(DrawCurve == TRUE  ){

    message(crayon::silver( "* Now, we draw the FROC and AFROC curves. \n"))
    message(crayon::silver( "* It takes time to draw FROC and AFROC curves. \n"))
    message(crayon::silver( "* Please wait ... . \n"))

    DrawCurves_MRMC(
      StanS4class = fit.new.class
    )


  }else{
    if(DrawCurve == FALSE  ){
      message(crayon::silver( "\n* We de not draw the FROC and AFROC curves. \n"))
      # message(" \n--------------------------------------------------  \n")

    } else{
      message(crayon::silver( "\n* DrawCurve is allowed only two choice; TRUE or FALSE. \n"))
    }
  }



  # is(fit,"stanfit")
  # getClass("stanfit")


  #Change the S4 object (fit) from old class to new class

  if(PreciseLogLikelihood==TRUE) {fit.new.class@WAIC <- waic(fit,dig,summary=FALSE)}
  fit.new.class@convergence    <-  convergence


  fit.new.class@plotdataMRMC  <-  metadata_to_DrawCurve_MRMC(fit.new.class,mesh.for.drawing.curve = mesh.for.drawing.curve)


  if(summary ==TRUE){
    # summary_AUC_comparison_MRMC(
    #   StanS4class=fit.new.class,
    #   significantLevel=significantLevel,
    #   dig=dig
    # )
    # summarize_MRMC(fit.new.class,dig=dig) # I put # for null hypothesis model at 2019.6.1
  }#if


  # extractAUC(
  #   StanS4class=fit.new.class,
  #   summary=summary,
  #   dig=dig
  # )
  if(summary ==FALSE){ message(crayon::silver( "\n* To see results, summary=TRUE \n"))}
  check_rhat(fit)


  rstan::check_hmc_diagnostics(fit)

  if(summary ==TRUE){size_of_return_value(summary=summary,object =  fit.new.class)}

  if ( dataList.Name==""   ) dataList.Name <-  deparse(substitute(dataList))
  fit.new.class@dataList.Name <- dataList.Name

  invisible(fit.new.class)




}

