% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Replicate_MRMC_data.R
\name{replicate_MRMC_dataList}
\alias{replicate_MRMC_dataList}
\title{MRMC: Replicator of Datasets}
\usage{
replicate_MRMC_dataList(initial.seed = 123,
  mu.truth = BayesianFROC::mu_truth, v.truth = BayesianFROC::v_truth,
  z.truth = BayesianFROC::z_truth, NI = 200, NL = 142,
  ModifiedPoisson = FALSE, No.of.replication = 2, summary = FALSE)
}
\arguments{
\item{initial.seed}{The variable \code{initial.seed} is used to replicate datasets. That is, if you take initial.seed = 1234, then the seed 1234, 1235, 1236, 1237, 1238, ….. are for the first replication, the second replication, the third replication, …. If the n-th model does not converge for some n, then such model has no mean and thus the non-convergent models are omitted to calculate the errors.}

\item{mu.truth}{array of dimension (M,Q). Mean of represents the signal distribution of bi-normal assumption.}

\item{v.truth}{array of dimension (M,Q). Standard Deviation of represents the signal distribution of bi-normal assumption.}

\item{z.truth}{This is a parameter of the latent Gaussian assumption for the noise distribution.}

\item{NI}{Number of Images.}

\item{NL}{Number of Lesions.}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE}, then Poisson rate of false alarm is \code{per lesion},
and if \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm is \code{per image}.
To know detail, refer the author's paper in which I explained per image and per lesion.(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  })

If \code{ModifiedPoisson = TRUE}, then False Positive Fraction (FPF) is calculated as follows
\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_L}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_L}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_L}, }

  \deqn{ \frac{f_4+f_5}{N_L}, }

   \deqn{ \frac{f_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).


On the other hand,


if \code{ModifiedPoisson = FALSE}(Default), then
\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_I}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_I}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_I}, }

  \deqn{ \frac{f_4+f_5}{N_I}, }

   \deqn{ \frac{f_5}{N_I}, }

where \eqn{N_I} is a number of images (trial).


So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it use only per trial. But, if we devide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author developed FROC theory to consider FROC analysis under per signal.


Revised 2019 6.19}

\item{No.of.replication}{For fixed number of lesions, images, the dataset of hits and false alarms are replicated, and the number of replicated datasets are specified by this variable.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}
}
\description{
From threshold, mean and S.D., it replicates datasets.
}
