% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_bi_normal.R
\name{draw_bi_normal}
\alias{draw_bi_normal}
\title{Visualization of Latent Gaussians}
\usage{
draw_bi_normal(StanS4class, dark_theme = TRUE, dig = 3, mesh = 1000)
}
\arguments{
\item{StanS4class}{This is an output of \code{rstan::stan()}. More precisely, an object of the inherited class of the S4 class stanfit.
That is, the stanfitExtended S4 class defined in this package.}

\item{dark_theme}{TRUE or FALSE}

\item{dig}{Digit for print of the outputs in the R console.}

\item{mesh}{Mesh for painting the area}
}
\value{
Information of Latent Gaussians, such as mean and S.D. of the signal distributions and thresholds.
}
\description{
Visualization of Latent Gaussians
}
\examples{
\donttest{

#            ----- High AUC case --------

     viewdata(dataList.High)

     fit.High <- fit_Bayesian_FROC(dataList.High,ite=111)

     draw_bi_normal(fit.High)




#            ----- Low AUC case --------

     viewdata(dataList.Low)

     fit.Low <- fit_Bayesian_FROC(dataList.Low)

     draw_bi_normal(fit.Low)

}# dottest
}
