% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_EAP_by_array.R
\name{extract_EAP_by_array}
\alias{extract_EAP_by_array}
\title{Extract Etimates Preserving Array Format.}
\usage{
extract_EAP_by_array(StanS4class, name.of.parameter)
}
\arguments{
\item{StanS4class}{This is an output of \code{rstan::stan()}.}

\item{name.of.parameter}{The name of parameter which user want to extract}
}
\value{
A list of datalists from the posterior predictive distribution
}
\description{
Extract EAP extimates by array format.
}
\details{
If an estimate is an array, then this function extract as an array. The \code{rstan} also has such function, i.e., \code{ rstan::get_posterior_mean()}. However this function does not extract as an array.
}
\examples{
 \donttest{

# Make a stanfit object. More precisely its extended class.

 fit <- fit_Bayesian_FROC( ite  = 1111 ,
                           summary = FALSE   ,
                           dataList = dataList.Chakra.Web.orderd,cha=1
                            )

#  One dimensional array

                  z   <- extract_EAP_by_array(fit,z)



#  Two dimensional array

                  AA  <- extract_EAP_by_array(fit,AA)


#  Three dimensional array

                  ppp <- extract_EAP_by_array(fit,ppp)



# ####1#### ####2#### ####3#### ####4#### ####5#### ####6#### ####7#### ####8#### ####9####
#     Of course, for the case of srsc, it is also available.
#   We shall show the case of srsc in which case the parameters are not array,
#   but in such a case we can extract estimates preserving its format such as vector.

 fit <- fit_Bayesian_FROC( ite  = 1111 ,
                           summary = FALSE   ,
                           dataList = dataList.Chakra.1,
                           cha=2
                            )

#  To extract the posterior mean for parameter A, we run the following;

  A <- extract_EAP_by_array(fit,A)

#  To extract the posterior mean for parameter z, we run the following;


 z <- extract_EAP_by_array(fit,z)

}# dottest

}
