% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JAGS-formula.R
\name{contr.meandif}
\alias{contr.meandif}
\title{Mean difference contrast matrix}
\usage{
contr.meandif(n, contrasts = TRUE)
}
\arguments{
\item{n}{a vector of levels for a factor, or the number of levels}

\item{contrasts}{logical indicating whether contrasts should be computed}
}
\value{
A matrix with n rows and k columns, with k = n - 1 if \code{contrasts = TRUE} and k = n
if \code{contrasts = FALSE}.
}
\description{
Return a matrix of mean difference contrasts.
This is an adjustment to the \code{contr.orthonormal} that ascertains that the prior
distributions on difference between the gran mean and factor level are identical independent
of the number of factor levels (which does not hold for the orthonormal contrast). Furthermore,
the contrast is re-scaled so the specified prior distribution exactly corresponds to the prior
distribution on difference between each factor level and the grand mean -- this is approximately
twice the scale of \code{contr.orthonormal}.
}
\examples{
contr.meandif(c(1, 2))
contr.meandif(c(1, 2, 3))

}
\references{
\insertAllCited{}
}
