% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-averaging-plots.R
\name{plot_models}
\alias{plot_models}
\title{Plot estimates from models}
\usage{
plot_models(
  model_list,
  samples,
  inference,
  parameter,
  plot_type = "base",
  prior = FALSE,
  conditional = FALSE,
  order = NULL,
  transformation = NULL,
  transformation_arguments = NULL,
  transformation_settings = FALSE,
  par_name = NULL,
  ...
)
}
\arguments{
\item{model_list}{list of models, each of which contains marginal
likelihood estimated with bridge sampling \code{marglik} and prior model
odds \code{prior_weights}}

\item{samples}{samples from a posterior distribution for a
parameter generated by \link{mix_posteriors}.}

\item{inference}{object created by \link{ensemble_inference} function}

\item{parameter}{parameter name to be plotted. Does not support
PET-PEESE and weightfunction.}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot"} for plotting.}

\item{prior}{whether prior distribution should be added to the figure}

\item{conditional}{whether conditional models should be displayed}

\item{order}{list specifying ordering of the models. The first
element describes whether the ordering should be \code{"increasing"}
or \code{"decreasing"} and the second element describes whether
the ordering should be based \code{"model"} order, \code{"estimate"}
size, posterior \code{"probability"}, or the inclusion \code{"BF"}.}

\item{transformation}{transformation to be applied
to the prior distribution. Either a character
specifying one of the prepared transformations:
\describe{
\item{lin}{linear transformation in form of \code{a + b*x}}
\item{tanh}{also known as Fisher's z transformation}
\item{exp}{exponential transformation}
}, or a list containing the transformation function \code{fun},
inverse transformation function \code{inv}, and the Jacobian of
the transformation \code{jac}. See examples for details.}

\item{transformation_arguments}{a list with named arguments for
the \code{transformation}}

\item{transformation_settings}{boolean indicating whether the
settings the \code{x_seq} or \code{x_range} was specified on
the transformed support}

\item{par_name}{a type of parameter for which the prior is
specified. Only relevant if the prior corresponds to a mu
parameter that needs to be transformed.}

\item{...}{additional arguments. E.g.:
\describe{
\item{\code{"show_updating"}}{whether Bayes factors and change from
prior to posterior odds should be shown on the secondary y-axis}
\item{\code{"show_estimates"}}{whether posterior estimates and 95\% CI
should be shown on the secondary y-axis}
\item{\code{"y_axis2"}}{whether the secondary y-axis should be shown}
}}
}
\value{
\code{plot_models} returns either \code{NULL} or
an object of class 'ggplot' if plot_type is \code{plot_type = "ggplot"}.
}
\description{
Plot estimates from models
}
\seealso{
\code{\link[=prior]{prior()}} \code{\link[=lines_prior_list]{lines_prior_list()}}  \code{\link[=geom_prior_list]{geom_prior_list()}}
}
