% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_common.R
\name{compileModelAndMCMC}
\alias{compileModelAndMCMC}
\title{Compile a NIMBLE model and its MCMC}
\usage{
compileModelAndMCMC(fullmodel)
}
\arguments{
\item{fullmodel}{Class "bsimSpline" and "bsimGp" object with sampling = FALSE}
}
\value{
A list with two elements:
\describe{
\item{\code{model}}{the compiled NIMBLE model (external pointer object).}
\item{\code{mcmc}}{the compiled MCMC function/algorithm bound to the model.}
}
}
\description{
Compiles a NIMBLE model object and a corresponding (uncompiled) MCMC
algorithm and returns the compiled pair.
}
\details{
The function first compiles \code{fullmodel$model} with
\code{nimble::compileNimble()}, then compiles \code{fullmodel$sampler} with
\code{nimble::compileNimble(project = model)}, where \code{model} is the
uncompiled model used to build the sampler. The compiled model and
compiled MCMC are returned as a list.
}
\examples{
\donttest{
# Split version
models <- bsplineFisher(DATA1$X, DATA1$y, sampling = FALSE)
Ccompile <- compileModelAndMCMC(models)
mcmc.out <- runMCMC(Ccompile$mcmc, niter = 5000, nburnin = 1000, thin = 1,
                   nchains = 1, setSeed = TRUE, inits = models$input$initial,
                   summary = TRUE, samplesAsCodaMCMC = TRUE)

}

}
\seealso{
\code{\link[nimble]{nimbleModel}},
\code{\link[nimble]{configureMCMC}},
\code{\link[nimble]{buildMCMC}},
\code{\link[nimble]{compileNimble}},
\code{\link[nimble]{runMCMC}}
}
