% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{smc_mallows_new_item_rank}
\alias{smc_mallows_new_item_rank}
\title{SMC-Mallows new item rank}
\usage{
smc_mallows_new_item_rank(
  n_items,
  R_obs,
  N,
  Time,
  logz_estimate,
  cardinalities,
  mcmc_kernel_app,
  aug_rankings_init = NULL,
  rho_samples_init = NULL,
  alpha_samples_init = 0L,
  alpha = 0,
  alpha_prop_sd = 0.5,
  lambda = 0.1,
  alpha_max = 1e+06,
  aug_method = "random",
  verbose = FALSE,
  alpha_fixed = FALSE,
  metric = "footrule",
  leap_size = 1L
)
}
\arguments{
\item{n_items}{Integer is the number of items in a ranking}

\item{R_obs}{3D matrix of size n_assessors by n_items by Time containing a set of observed rankings of Time time steps}

\item{N}{Integer specifying the number of particles}

\item{Time}{Integer specifying the number of time steps in the SMC algorithm}

\item{logz_estimate}{Estimate of the partition function, computed with
\code{\link{estimate_partition_function}}.}

\item{cardinalities}{Cardinalities for exact computation of partition function,
returned from \code{\link{prepare_partition_function}}.}

\item{mcmc_kernel_app}{Integer value for the number of applications we apply the MCMC move kernel}

\item{aug_rankings_init}{Initial values for augmented rankings.}

\item{rho_samples_init}{Initial values for rho samples.}

\item{alpha_samples_init}{Initial values for alpha samples.}

\item{alpha}{numeric value of the scale parameter.}

\item{alpha_prop_sd}{Numeric value of the standard deviation of the prior distribution for alpha}

\item{lambda}{Strictly positive numeric value specifying the rate parameter
of the truncated exponential prior distribution of alpha.}

\item{alpha_max}{Maximum value of alpha in the truncated exponential
prior distribution.}

\item{aug_method}{A character string specifying the approach for filling in the missing data, options are "pseudolikelihood" or "random"}

\item{verbose}{Logical specifying whether to print out the progress of the
SMC-Mallows algorithm. Defaults to \code{FALSE}.}

\item{alpha_fixed}{Logical indicating whether to sample \code{alpha} or not.}

\item{metric}{A character string specifying the distance metric to use in the
Bayesian Mallows Model. Available options are \code{"footrule"},
\code{"spearman"}, \code{"cayley"}, \code{"hamming"}, \code{"kendall"}, and
\code{"ulam"}.}

\item{leap_size}{leap_size Integer specifying the step size of the leap-and-shift
proposal distribution}
}
\value{
a 3d matrix containing: the samples of: rho, alpha and the augmented rankings, and the effective sample size at each iteration of the SMC algorithm.
}
\description{
Function to perform resample-move SMC algorithm where we receive a new item ranks from an existing user
at each time step. Each correction and augmentation is done by filling in the missing item ranks using pseudolikelihood augmentation.
}
\seealso{
Other modeling: 
\code{\link{compute_mallows_mixtures}()},
\code{\link{compute_mallows}()},
\code{\link{smc_mallows_new_users}()}
}
\concept{modeling}
