% package: BayesLogit
\name{rpg}

\alias{rpg}
\alias{rpg.gamma}
\alias{rpg.gamma.R}
\alias{rpg.devroye}
\alias{rpg.devroye.R}

\title{The Polya-Gamma Distribution}

\description{
  Generate a random variate from the Polya-Gamma distribution.
}

\details{

  A random variable X with distribution PG(n,z) is generated by

  \deqn{ X \sim \sum_{k=1}^\infty G(n,1) / ( 2 \pi^2 (k-1/2)^2 + z^2/2). }

  The density for X may be derived from Z and PG(n,0) as

  \deqn{ p(x|n,z) \propto \exp(-x z^2/2) p(x|n,0).}

  Thus PG(n,z) is an exponentially tilted PG(n,0).

  Two different methods for generating this random variable are
  implemented.  In general, you may use rpg.gamma to generate an
  approximation of PG(n,z) using the sum of Gammas representation
  above.  When n is a natural number you may use \code{rpg.devroye} to
  sample PG(n,z).  The later method is fast.

}

\usage{

rpg.gamma(num=1, n=1, z=0.0, trunc=200)

rpg.devroye(num=1, n=1, z=0.0)

}

% rpg.gamma.R(num=1, n=1, z=0.0, trunc=200)

% rpg.devroye.R(num=1, n=1, z=0.0)

\arguments{
	
  You may call rpg when n and z are vectors.

  \item{num}{The number of random variates to simulate.}
  \item{n}{Shape parameter.}
  \item{z}{Parameter associated with tilting.}
  \item{trunc}{The number of elements used in sum of gammas approximation.}
}

\value{

  This function returns \code{num} Polya-Gamma samples.

}

\examples{

a = c(1, 2, 3);
b = c(4, 5, 6);

## If a is only integers, use Devroye-like method.
X = rpg.devroye(100, a, b);

a = c(1.2, 2.3, 3.2);
b = c(4, 5, 6);

## If a has scalars use sum-of-gammas method.
X = rpg.gamma(100, a, b);

}

\seealso{
  \code{\link{logit.EM}}, \code{\link{logit}}, \code{\link{mlogit}}
}

\references{
  Nicholas G. Polson, James G. Scott, and Jesse Windle.  Bayesian inference for
  logistic models using Polya-Gamma latent variables.
  \url{http://arxiv.org/abs/1205.0310}
}

\keyword{rpg}
\keyword{Polya-Gamma}
\keyword{polyagamma}
