% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissplot.R
\name{dissplot}
\alias{dissplot}
\title{Dissolution Data Plot}
\usage{
dissplot(
  dis_data,
  tp = NULL,
  pch = c(19, 17),
  color = c("gray65", "black"),
  groups = c("Reference", "Test"),
  legend_location = "bottomright",
  xlab = "Time Points",
  ylab = "Percentage Dissolved",
  mean = FALSE,
  var = FALSE,
  var_label = TRUE,
  ...
)
}
\arguments{
\item{dis_data}{A data frame containing the dissolution data. The first column of the data frame should denote
the group labels identifying whether a given dissolution belongs to the "reference" or "test" formulation group.
For a given dissolution run, the remaining columns of the data frame contains the individual run's dissolution
measurements sorted in time.}

\item{tp}{An optional vector of time points at which the dissolution data is measured at.}

\item{pch}{A vector of two elements specifying the plotting character to use for each group. If only one value is passed then the plotting character is the same for both groups.}

\item{color}{A vector of two elements specifying the color in the plot to associate with each group. If only one value is passed then the color choice is the same for both groups.}

\item{groups}{A vector of two elements specifying the name to use for each group in the plot.}

\item{legend_location}{A string that denotes the location of where the legend should appear. Possible options are "left", "top", "bottom", "right", and any logical combination of the four, e.g., "bottomright" or "topleft".}

\item{xlab}{A string specifying the x-axis label.}

\item{ylab}{A string specifying the y-axis label.}

\item{mean}{logical; if \code{TRUE}, plot the connected mean dissolution values for each group}

\item{var}{logical; if \code{TRUE}, calculate the variance of the dissolution data at each time point for each group. The values are placed at the top of the plot over the corresponding time point.}

\item{var_label}{logical; if \code{TRUE}, use the group labels when printing out the variances.}

\item{...}{other graphical parameters commonly found in \link[graphics]{plot.default}}
}
\value{
The function returns a plot of the dissolution data.
}
\description{
This function plots dissolution data sets.
}
\examples{
### dis_data comes loaded with the package
dissplot(dis_data)

}
