% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{get.clean.data}
\alias{get.clean.data}
\title{Get clean data from yahoo/google}
\usage{
get.clean.data(tickers, src = "yahoo", first.date, last.date)
}
\arguments{
\item{tickers}{A vector of tickers. If not sure whether the ticker is available, check the websites of google and yahoo finance. The source for downloading
the data can either be Google or Yahoo. The function automatically selects the source webpage based on the input ticker.}

\item{src}{Source of data (yahoo or google)}

\item{first.date}{The first date to download data (date or char as YYYY-MM-DD)}

\item{last.date}{The last date to download data (date or char as YYYY-MM-DD)}
}
\value{
A dataframe with the cleaned data
}
\description{
Get clean data from yahoo/google
}
\examples{
df.sp500 <- get.clean.data('^GSPC',
                           first.date = as.Date('2010-01-01'),
                           last.date = as.Date('2010-02-01'))
}
