% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BatchGetSymbols.R
\name{BatchGetSymbols}
\alias{BatchGetSymbols}
\title{Function to download financial data}
\usage{
BatchGetSymbols(
  tickers,
  first.date = Sys.Date() - 30,
  last.date = Sys.Date(),
  thresh.bad.data = 0.75,
  bench.ticker = "^GSPC",
  type.return = "arit",
  freq.data = "daily",
  how.to.aggregate = "first",
  do.complete.data = FALSE,
  do.fill.missing.prices = TRUE,
  do.cache = TRUE,
  cache.folder = "BGS_Cache",
  do.parallel = FALSE,
  be.quiet = FALSE
)
}
\arguments{
\item{tickers}{A vector of tickers. If not sure whether the ticker is available, check the websites of google and yahoo finance. The source for downloading
the data can either be Google or Yahoo. The function automatically selects the source webpage based on the input ticker.}

\item{first.date}{The first date to download data (date or char as YYYY-MM-DD)}

\item{last.date}{The last date to download data (date or char as YYYY-MM-DD)}

\item{thresh.bad.data}{A percentage threshold for defining bad data. The dates of the benchmark ticker are compared to each asset. If the percentage of non-missing dates
with respect to the benchmark ticker is lower than thresh.bad.data, the function will ignore the asset (default = 0.75)}

\item{bench.ticker}{The ticker of the benchmark asset used to compare dates. My suggestion is to use the main stock index of the market from where the data is coming from (default = ^GSPC (SP500, US market))}

\item{type.return}{Type of price return to calculate: 'arit' (default) - aritmetic, 'log' - log returns.}

\item{freq.data}{Frequency of financial data ('daily', 'weekly', 'monthly', 'yearly')}

\item{how.to.aggregate}{defines whether to aggregate the data using the first observations of the period or last ('first', 'last')}

\item{do.complete.data}{Return a complete/balanced dataset? If TRUE, all missing pairs of ticker-date will be replaced by NA or closest price (see input do.fill.missing.prices). Default = FALSE.}

\item{do.fill.missing.prices}{Finds all missing prices and replaces them by their closest price with preference for the previous price. This ensures a balanced dataset for all assets, without any NA. Default = TRUE.}

\item{do.cache}{Use caching system? (default = TRUE)}

\item{cache.folder}{Where to save cache files? (default = 'BGS_Cache')}

\item{do.parallel}{Flag for using parallel or not (default = FALSE). Before using parallel, make sure you call function future::plan() first.}

\item{be.quiet}{Logical for printing statements (default = FALSE)}
}
\value{
A list with the following items: \describe{
\item{df.control }{A dataframe containing the results of the download process for each asset}
\item{df.tickers}{A dataframe with the financial data for all valid tickers} }
}
\description{
This function is designed to make batch downloads of financial data using \code{\link[quantmod]{getSymbols}}.
Based on a set of tickers and a time period, the function will download the data for each ticker and return a report of the process, along with the actual data in the long dataframe format.
The main advantage of the function is that it automatically recognizes the source of the dataset from the ticker and structures the resulting data from different sources in the long format.
A caching system is also presente, making it very fast.
}
\section{Warning}{


Do notice that adjusted prices are not available from google finance. When using this source, the function will output NA values for this column.
}

\examples{
tickers <- c('FB','MMM')

first.date <- Sys.Date()-30
last.date <- Sys.Date()

l.out <- BatchGetSymbols(tickers = tickers,
                         first.date = first.date,
                        last.date = last.date, do.cache=FALSE)

print(l.out$df.control)
print(l.out$df.tickers)
}
\seealso{
\link[quantmod]{getSymbols}
}
