% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateRadialPlot.R
\name{CreateRadialPlot}
\alias{CreateRadialPlot}
\title{R function CreateRadialPlot by William D. Vickers, freely downloadable from the web}
\usage{
CreateRadialPlot(
  plot.data,
  axis.labels = colnames(plot.data)[-1],
  grid.min = -0.5,
  grid.mid = 0,
  grid.max = 0.5,
  centre.y = grid.min - ((1/9) * (grid.max - grid.min)),
  plot.extent.x.sf = 1.2,
  plot.extent.y.sf = 1.2,
  x.centre.range = 0.02 * (grid.max - centre.y),
  label.centre.y = FALSE,
  grid.line.width = 0.5,
  gridline.min.linetype = "longdash",
  gridline.mid.linetype = "longdash",
  gridline.max.linetype = "longdash",
  gridline.min.colour = "grey",
  gridline.mid.colour = "blue",
  gridline.max.colour = "grey",
  grid.label.size = 4,
  gridline.label.offset = -0.02 * (grid.max - centre.y),
  label.gridline.min = TRUE,
  axis.label.offset = 1.15,
  axis.label.size = 2.5,
  axis.line.colour = "grey",
  group.line.width = 1,
  group.point.size = 4,
  background.circle.colour = "yellow",
  background.circle.transparency = 0.2,
  plot.legend = if (nrow(plot.data) > 1) TRUE else FALSE,
  legend.title = "Player",
  legend.text.size = grid.label.size,
  titolo = FALSE
)
}
\arguments{
\item{plot.data}{plot.data}

\item{axis.labels}{axis.labels}

\item{grid.min}{grid.min}

\item{grid.mid}{grid.mid}

\item{grid.max}{grid.max}

\item{centre.y}{centre.y}

\item{plot.extent.x.sf}{plot.extent.x.sf}

\item{plot.extent.y.sf}{plot.extent.y.sf}

\item{x.centre.range}{x.centre.range}

\item{label.centre.y}{label.centre.y}

\item{grid.line.width}{grid.line.width}

\item{gridline.min.linetype}{gridline.min.linetype}

\item{gridline.mid.linetype}{gridline.mid.linetype}

\item{gridline.max.linetype}{gridline.max.linetype}

\item{gridline.min.colour}{gridline.min.colour}

\item{gridline.mid.colour}{gridline.mid.colour}

\item{gridline.max.colour}{gridline.max.colour}

\item{grid.label.size}{grid.label.size}

\item{gridline.label.offset}{gridline.label.offset}

\item{label.gridline.min}{label.gridline.min}

\item{axis.label.offset}{axis.label.offset}

\item{axis.label.size}{axis.label.size}

\item{axis.line.colour}{axis.line.colour}

\item{group.line.width}{group.line.width}

\item{group.point.size}{group.point.size}

\item{background.circle.colour}{background.circle.colour}

\item{background.circle.transparency}{background.circle.transparency}

\item{plot.legend}{plot.legend}

\item{legend.title}{legend.title}

\item{legend.text.size}{legend.text.size}

\item{titolo}{plot title}
}
\description{
R function CreateRadialPlot by William D. Vickers, freely downloadable from the web
}
\details{
A description of the function can be found at the following link: \url{http://rstudio-pubs-static.s3.amazonaws.com/5795_e6e6411731bb4f1b9cc7eb49499c2082.html}
}
\references{
Vickers D.W. (2006) Multi-Level Integrated Classifications Based on the 2001 Census, PhD Thesis, School of Geography, The University of Leeds
}
