% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{addSubs}
\alias{addSubs}
\alias{addSubs,Arena-method}
\title{Add substances to the environment}
\usage{
addSubs(object, smax = 0, mediac = object@mediac, difunc = "pde",
  pde = "Diff2d", difspeed = 6.7e-06, unit = "mmol/cell", add = TRUE,
  diffmat = NULL, template = FALSE, Dgrid = NULL, Vgrid = NULL,
  addAnyway = FALSE)

\S4method{addSubs}{Arena}(object, smax = 0, mediac = object@mediac,
  difunc = "pde", pde = "Diff2d", difspeed = 6.7e-06,
  unit = "mmol/cell", add = TRUE, diffmat = NULL, template = FALSE,
  Dgrid = NULL, Vgrid = NULL, addAnyway = FALSE)
}
\arguments{
\item{object}{An object of class Arena.}

\item{smax}{A numeric vector indicating the maximum substance concentration per grid cell.}

\item{mediac}{A character vector giving the names of substances, which should be added to the environment (the default takes all possible substances).}

\item{difunc}{A character vector ("pde","cpp" or "r") describing the function for diffusion.}

\item{pde}{Choose diffusion transport reaction to be used (default is diffusion only)}

\item{difspeed}{A number indicating the diffusion speed (given by number of cells per iteration).}

\item{unit}{A character used as chemical unit to set the amount of the substances to be added (valid values are: mmol/cell, mmol/cm2, mmol/arena, mM)}

\item{add}{A boolean variable defining whether the amount of substance should be summed or replaced}

\item{diffmat}{A matrix with spatial distributed initial concentrations (if not set, a homogenous matrix using smax is created)}

\item{template}{True if diffmat matrix should be used as tempalte only (will be multiplied with smax to obtain cocentrations)}

\item{Dgrid}{A matrix indicating the diffusion speed in x and y direction (given by cm^2/h).}

\item{Vgrid}{A number indicating the advection speed in x direction (given by cm/h).}

\item{addAnyway}{If true substance will be added even if there is no connection (i.e. exchanges) with organisms}
}
\description{
The generic function \code{addSubs} adds specific substances to the environment.
}
\details{
If nothing but \code{object} is given, then all possible substrates are initilized with a concentration of 0. Afterwards, \code{\link{changeSub} can be used to modify the concentrations of specific substances.}
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,20,c("EX_glc(e)","EX_o2(e)","EX_pi(e)")) #add glucose, o2, pi
}
\seealso{
\code{\link{Arena-class}} and \code{\link{changeSub}}
}
