% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{findRxnFlux}
\alias{findRxnFlux}
\alias{findRxnFlux,Eval-method}
\title{Function to get all reactions fluxes that are associated with the metabolite of a given exchange reactions}
\usage{
findRxnFlux(object, ex, time, print_reactions = FALSE, drop_unused = TRUE)

\S4method{findRxnFlux}{Eval}(object, ex, time, print_reactions = FALSE,
  drop_unused = TRUE)
}
\arguments{
\item{object}{An object of class Eval.}

\item{ex}{An exchange reaction of which the metabolite should be shared for in all reactions}

\item{time}{the time point of the simulation which should be considered}

\item{print_reactions}{If true the detailed definition of each reactions is printed}

\item{drop_unused}{If true then inactive reactions will be excluded}
}
\description{
The generic function \code{findRxnFlux} returns a matrix with the flux for each organism and the reaction that is using the metabolite of the given exchange reaction
}
\details{
Returns a list with the minimum and maximum substance usage for each time point.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,5)
fluxlist <- findRxnFlux(eval, "EX_h(e)", 5)
}
\seealso{
\code{\link{Eval-class}} and \code{\link{simEnv}}
}
