## ------------------------------------------------------------------------
library("BacArena")

## ------------------------------------------------------------------------
data(Ec_core)
ecore <- Ec_core

## ------------------------------------------------------------------------
bac <- Bac(ecore, growtype="exponential", cellarea=4.42, lyse=T)

## ------------------------------------------------------------------------
arena = Arena(n=100, m=100, Lx=0.025, Ly=0.025)

## ------------------------------------------------------------------------
addOrg(arena,bac,amount=1,x=50,y=50)

## ------------------------------------------------------------------------
addSubs(arena, smax=0.05, difspeed=6.7e-6, unit='mM') 

## ------------------------------------------------------------------------
eval <- simEnv(arena,time=20)

## ------------------------------------------------------------------------
plotCurves2(eval)

## ------------------------------------------------------------------------
evalArena(eval,time=20)

## ------------------------------------------------------------------------
par(mar=c(1,1,1,1))
evalArena(eval,c("Population","EX_glc(e)"),time=20)

## ------------------------------------------------------------------------
par(mar=c(1,1,1,1))
evalArena(eval,c("Population","EX_glc(e)"),phencol=T,time=20)

## ------------------------------------------------------------------------
minePheno(eval)

## ------------------------------------------------------------------------
pmat <- getPhenoMat(eval)

## ------------------------------------------------------------------------
bac1 <- Bac(ecore,deathrate=0.1,type="ecoli_wt",
           growthlimit=0.05,growtype="exponential")

## ------------------------------------------------------------------------
ecore_aux <- changeBounds(ecore,"EX_o2(e)",lb=0)
bac2 <- Bac(ecore_aux,deathrate=0.1,type="ecoli_aux",
           growthlimit=0.05,growtype="exponential")

## ------------------------------------------------------------------------
arena = Arena(n=100, m=100, Lx=0.025, Ly=0.025)
addOrg(arena,bac1,amount=1,x=25,y=50)
addOrg(arena,bac2,amount=1,x=75,y=50)
addSubs(arena,100)
eval <- simEnv(arena,time=20)

## ------------------------------------------------------------------------
plotCurves2(eval)

## ------------------------------------------------------------------------
par(mar=c(1,1,1,1))
evalArena(eval,c("Population","EX_glc(e)","EX_ac(e)","EX_o2(e)"),
          time=20)

## ------------------------------------------------------------------------
minePheno(eval)
print(getPhenoMat(eval))

