% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{methods}
\name{cellgrowth}
\alias{cellgrowth}
\alias{cellgrowth,Human-method}
\title{Function implementing a growth model of a human cell}
\usage{
cellgrowth(object, population, j)

\S4method{cellgrowth}{Human}(object, population, j)
}
\arguments{
\item{object}{An object of class Human.}

\item{population}{An object of class Arena.}

\item{j}{The number of the iteration of interest.}
}
\value{
Boolean variable of the \code{j}th individual indicating if individual died.
}
\description{
The generic function \code{cellgrowth} implements different growth models for an object of class Human.
}
\details{
Linear growth of organisms is implemented by adding the calculated growthrate by \code{optimizeLP} to the already present growth value. Exponential growth of organisms is implemented by adding the calculated growthrate multiplied with the current growth calculated by \code{optimizeLP} plus to the already present growth value.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
human <- Human(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
addOrg(arena,human,amount=10) #add 10 organisms
addSubs(arena,40) #add all possible substances
cellgrowth(human,arena,1)
}
\seealso{
\code{\link{Human-class}}, \code{\link{growLin}} and \code{\link{growExp}}
}

