% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class_definitions.R
\docType{class}
\name{mixedRegression-class}
\alias{mixedRegression-class}
\title{S4 class of model informations for the hierarchical (mixed) regression model}
\description{
Informations of model
  \eqn{y_{ij} = f(\phi_j, t_{ij}) + \epsilon_{ij}, \phi_j\sim N(\mu, \Omega),
  \epsilon_{ij}\sim N(0,\gamma^2\widetilde{s}(t_{ij}))}.
}
\section{Slots}{

\describe{
\item{\code{phi}}{parameter \eqn{\phi}}

\item{\code{mu}}{parameter \eqn{\mu}}

\item{\code{Omega}}{parameter \eqn{\Omega}}

\item{\code{gamma2}}{parameter \eqn{\gamma^2}}

\item{\code{fun}}{function \eqn{f(\phi, t)}}

\item{\code{sT.fun}}{function \eqn{\widetilde{s}(t)}}

\item{\code{prior}}{list of prior parameters}

\item{\code{start}}{list of starting values for the Metropolis within Gibbs sampler}
}}
\examples{
mu <- c(2, 1); Omega <- c(1, 0.04)
phi <- sapply(1:2, function(i) rnorm(21, mu[i], sqrt(Omega[i])))
parameter <- list(phi = phi, mu = mu, Omega = Omega, gamma2 = 0.01)
fun <- function(phi, t) phi[1] + phi[2]*t
sT.fun <- function(t) t
prior <- list(m.mu = parameter$mu, v.mu = parameter$mu^2,
   alpha.omega = rep(3, length(parameter$mu)), beta.omega = parameter$Omega*2,
   alpha.gamma = 3, beta.gamma = parameter$gamma2*2)
start <- parameter
model <- set.to.class("mixedRegression", parameter, prior, start, fun = fun, sT.fun = sT.fun)
}

