% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim.R
\name{sim_DGP}
\alias{sim_DGP}
\title{Simulate a Nonstationary Panel With Common Trends}
\usage{
sim_DGP(
  N = 100,
  n_Periods = 200,
  drift = TRUE,
  drift_I1 = TRUE,
  r_I1 = 2,
  r_I0 = 1,
  return_factor = FALSE
)
}
\arguments{
\item{N}{the number of cross-sectional units.}

\item{n_Periods}{the number of simulated time periods.}

\item{drift}{logical. If \code{TRUE}, a linear trend is included (corresponding to both \emph{d_1 = 1} and \emph{r_1 = 1}).}

\item{drift_I1}{logical. If \code{TRUE}, an \emph{I(1)} factor moves around the linear trend. Else an \emph{I(0)} factor (corresponding to \emph{d_2 = 1}).}

\item{r_I1}{the total number of non zero-mean \emph{I(1)} factors (corresponding to \emph{r_2 + r_1 * d_2}).}

\item{r_I0}{the total number of non zero-mean \emph{I(0)} factors (corresponding to \emph{r_3 + r_1 * (1 - d_2)}).}

\item{return_factor}{logical. If \code{TRUE}, the factor matrix is returned. Else the simulated observations. Default is \code{FALSE}.}
}
\value{
A (\emph{T x N}) matrix of simulated observations. If \code{return_factor = TRUE}, a (\emph{N x r}) matrix of factors.
}
\description{
Simulate a nonstationary panel as laid out in Barigozzi & Trapani (2022, sec. 5).
}
\details{
For further details on the construction of the DGP, see Barigozzi & Trapani (2022, sec. 5).
}
\examples{
# Simulate a panel containing a factor with a linear drift (r_1 = d_1 = 1) and I(1) process
# (d_2 = 1), one zero-mean I(1) factor (r_2 = 1) and two zero-mean I(0) factors (r_3 = 2)
X <- sim_DGP(N = 100, n_Periods = 200, drift = TRUE, drift_I1 = TRUE, r_I1 = 2, r_I0 = 2)

# Simulate a panel containing only 3 common zero-mean I(0) factor (r_1 = 0, r_2 = 0, r_3 = 3)
X <- sim_DGP(N = 100, n_Periods = 200, drift = FALSE, drift_I1 = TRUE, r_I1 = 0, r_I0 = 3)
}
\references{
Barigozzi, M., & Trapani, L. (2022). Testing for common trends in nonstationary large datasets. \emph{Journal of Business & Economic Statistics}, 40(3), 1107-1122. \doi{10.1080/07350015.2021.1901719}
}
\author{
Paul Haimerl
}
