% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trace.R
\name{plot_trace}
\alias{plot_trace}
\title{Creates trace plots of specified parameters showing the multiple chains and
the value of Rhat}
\usage{
plot_trace(
  title = " ",
  results = NULL,
  parms_to_plot = NULL,
  nrow = 2,
  ncol = 2
)
}
\arguments{
\item{title}{A character string used for a title on reports and graphs}

\item{results}{The MCMC object containing the results from the call to JAGS}

\item{parms_to_plot}{A character vector of names of parameters to plot.
These must match exactly to the parameter names used in the simulation.}

\item{ncol, nrow}{How many plots to put on a page (number of rows and columns)}
}
\value{
List of ggplot2 objects using facet_wrap_paginate (...., page=...) with each element of the list
corresponding to one page of the plot.
}
\description{
Takes the MCMC object returned from a split and produces trace_plots for the
listed parameters. It shows a separate line on the plot for each chain and
also shows the value of Rhat
}
\examples{
\dontrun{
# Create trace plots of the logitP parameters
# 
# Trace plots of logitP
varnames <- names(results$sims.array[1,1,])  # extract the names of the variables 
trace.plot <- plot_trace(title=title, 
                         results=results, 
                         parms_to_plot=varnames[grep("^logitP", varnames)])
if(save.output.to.files){
  pdf(file=paste(prefix,"-trace-logitP.pdf",sep=""))
  plyr::l_ply(trace.plot, function(x){plot(x)})
  dev.off()
}
} # end of dontrun

}
\author{
Bonner, S.J. \email{sbonner6@uwo.ca} and 
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
\keyword{internal}
