# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Simulation function of the cell biology example
#'
#' @description Simulation function of the cell biology example.
#' @param x The initial matrix of cell presences of size \code{rows}
#' \ifelse{html}{\out{&times}}{\eqn{\times}} \code{cols}.
#' @param Pm Parameter \ifelse{html}{\out{<i>P<sub>m</sub></i>}}{\eqn{P_m}},
#' the probability of cell movement.
#' @param Pp Parameter \ifelse{html}{\out{<i>P<sub>p</sub></i>}}{\eqn{P_p}},
#' the probability of cell proliferation.
#' @inheritParams cell
#' @return  A \code{rows} \ifelse{html}{\out{&times}}{\eqn{\times}} \code{cols}
#'  \ifelse{html}{\out{&times}}{\eqn{\times}} \code{num_obs} array
#'   of the cell presences at times \code{1:num_obs} (not time 0).
#' @export
simulate_cell <- function(x, rows, cols, Pm, Pp, sim_iters, num_obs) {
    .Call(`_BSL_simulate_cell`, x, rows, cols, Pm, Pp, sim_iters, num_obs)
}

#' Generate a random sample from the zero-centered stable distribution
#'
#' @description Draw a sample from a symmetric, zero-centered stable distribution with
#' given scale and stability (alpha) parameters, using the CMS algorithm.
#' @param scale The scale parameter.
#' @param alpha The stability parameter.
#' @return  A random sample from the zero-centered stable distribution.
#' @keywords internal
rstable <- function(scale, alpha) {
    .Call(`_BSL_rstable`, scale, alpha)
}

#' The simulation function for the toad example
#'
#' @description The simulation function for the toad example.
#' @param params A vector of proposed model parameters, \ifelse{html}{\out{<i>&#945</i>}}{\eqn{\alpha}},
#'   \ifelse{html}{\out{<i>&#947</i>}}{\eqn{gamma}} and \ifelse{html}{\out{p<sub>0</sub>}}{\eqn{p_0}}.
#' @param ntoad The number of toads to simulate in the observation.
#' @param nday The number of days lasted of the observation.
#' @param model Which model to be used. 1 for the random return model, 2 for the nearest return model,
#'   and 3 for the distance-based return probability model.
#' @param d0 Characteristic distance for model 3. Only used if model is 3.
#' @return A data matrix.
#' @examples sim_toad(c(1.7,36,0.6), 10, 8, 1)
#' @export
sim_toad <- function(params, ntoad, nday, model = 1L, d0 = 100) {
    .Call(`_BSL_sim_toad`, params, ntoad, nday, model, d0)
}

#' Convert an observation matrix to a vector of n-day displacements
#'
#' @description Convert an observation matrix to a vector of n-day
#' displacements. This is a function for the toad example.
#' @param X The observation matrix to be converted.
#' @param lag Interger, the number of day lags to compute the displacement.
#' @return A vector of displacements.
#' @export
obsMat2deltax <- function(X, lag) {
    .Call(`_BSL_obsMat2deltax`, X, lag)
}

