% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiparaKernelEstimate.R
\name{semiparaKernelEstimate}
\alias{semiparaKernelEstimate}
\title{Estimating the semi-parametric joint likelihood}
\usage{
semiparaKernelEstimate(ssy, ssx, kernel = "gaussian", shrinkage = NULL,
  penalty = NULL, log = TRUE)
}
\arguments{
\item{ssy}{The observed summary statistic.}

\item{ssx}{A matrix of the simulated summary statistics. The number of rows is the same
as the number of simulations per iteration.}

\item{kernel}{A string argument indicating the smoothing kernel to pass into
\code{density} for estimating the marginal distribution of each summary statistic. Only ``gaussian"
and ``epanechnikov" are available. The default is ``gaussian".}

\item{shrinkage}{A string argument indicating which shrinkage method to be used on the
correlation matrix of the Gaussian copula. The default is \code{NULL}, which means no shrinkage
is used. Current options are ``glasso" for graphical lasso and ``Warton" for the ridge
regularisation method of Warton (2008).}

\item{penalty}{The penalty value to be used for the specified shrinkage method. Must be between zero and one
if the shrinkage method is ``Warton''.}

\item{log}{A logical argument indicating if the log of the likelihood is given as the result.
The default is \code{TRUE}.}
}
\value{
The estimated synthetic (log) likelihood value.
}
\description{
This function computes the semi-parametric likelihood estimator of An et al (2018).
Kernel density estimates are used for modelling each univariate marginal distribution, and the
dependence structure between summaries are captured using a Gaussian copula.
}
\examples{
data(ma2)
y <- ma2$data # the observed data

theta_true <- c(0.6, 0.2)
x <- matrix(0, 300, 50)
set.seed(100)
for(i in 1:300) x[i, ] <- ma2_sim(theta_true, 50)

# the default semi-parametric synthetic likelihood estimator of semiBSL
semiparaKernelEstimate(y, x)
# using shrinkage on the correlation matrix of the Gaussian copula is also possible
semiparaKernelEstimate(y, x, shrinkage = 'Warton', penalty = 0.6)

}
\references{
An, Z., Nott, D. J. &  Drovandi, C. (2018). Robust Bayesian Synthetic Likelihood via
a Semi-Parametric Approach. \url{https://arxiv.org/abs/1809.05800}

Friedman, J., Hastie, T., Tibshirani, R. (2008). Sparse inverse covariance estimation with
the graphical lasso. Biostatistics. \url{https://doi.org/10.1093/biostatistics/kxm045}

Warton, D. I. (2008). Penalized Normal Likelihood and Ridge Regularization of Correlation and
Covariance Matrices, Journal of the American Statistical Association.
\url{https://www.tandfonline.com/doi/abs/10.1198/016214508000000021}
}
\seealso{
\code{\link{gaussianSynLike}} for the standard synthetic likelihood estimator, 
\code{\link{gaussianSynLikeGhuryeOlkin}} for the unbiased synthetic likelihood estimator.
}
