% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4Functions.R
\name{plot.bsl}
\alias{plot.bsl}
\alias{marginalPostDefault}
\alias{marginalPostGgplot}
\title{Plot method for class ``bsl''}
\usage{
plot.bsl(x, which = 1L, thin = 1, thetaTrue = NULL,
  options.plot = NULL, top = "Approximate Univariate Posteriors",
  options.density = list(), options.theme = list())

marginalPostDefault(x, thin = 1, thetaTrue = NULL,
  options.plot = NULL)

marginalPostGgplot(x, thin = 1, thetaTrue = NULL,
  top = "Approximate Univariate Posteriors", options.density = list(),
  options.theme = list())
}
\arguments{
\item{x}{A ``bsl'' class object to plot.}

\item{which}{An integer argument indicating which plot function to be used. The default, \code{1L}, uses
the plain \code{plot} to visualise the result. \code{2L} uses ggplot2 to generate an aesthetically nicer figure.}

\item{thin}{A numeric argument indicating the gap between samples to be taken when thinning the MCMC
draws. The default is \code{1L}, which means no thinning is used.}

\item{thetaTrue}{A set of values to be included on the plots as a reference line. The default is \code{NULL}.}

\item{options.plot}{A list of additional arguments to pass into the \code{plot} function. Only use when
\code{which} is \code{1L}.}

\item{top}{A string argument of the combined plot title if \code{which} is \code{2L}.}

\item{options.density}{A list of additional arguments to pass into the \code{geom_density} function. Only use
when \code{which} is \code{2L}.}

\item{options.theme}{A list of additional arguments to pass into the \code{theme} function. Only use
when \code{which} is \code{2L}.}
}
\description{
Plot the univariate marginal posterior plot of a bsl class object.
}
\examples{
\dontrun{
# pretend we had a bsl result
result <- new('bsl')
result@theta <- MASS::mvrnorm(10000, c(0.6, 0.2), diag(c(1, 1)))
result@M <- 10000

# plot using the R default plot function
par(mar = c(5, 4, 1, 2), oma = c(0, 1, 3, 0))
plot(result, which = 1, thin = 10, thetaTrue = c(0.6, 0.2),
     options.plot = list(cex.main = 1, col = 'red', lty = 2, lwd = 2, main = NA))
mtext('Approximate Univariate Posteriors', outer = TRUE, cex = 1.5)

# plot using the ggplot2 package
plot(result, which = 2, thin = 10, thetaTrue = c(0.6, 0.2),
     options.density = list(colour = 'darkblue', fill = 'grey80', size = 1),
     options.theme = list(plot.margin = grid::unit(rep(0.05,4), 'npc'),
                          axis.text = ggplot2::element_text(size = 10)))
}

}
\seealso{
\code{\link[BSL:combinePlotsBSL]{combinePlotBSL}} for a function to plot multiple BSL densities.
}
\author{
Ziwen An, Leah F. South and Christopher C. Drovandi
}
