% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Track}
\alias{Track}
\title{National Olympic records for women in several races}
\format{
A data frame with 55 observations on eight variables
\describe{ 
\item{country}{athlete's country} 
\item{100m}{time in seconds for 100 m} 
\item{200m}{time in seconds for 200 m}
\item{400m}{time in seconds for 400 m} 
\item{800m}{time in minutes for 800 m} 
\item{1500m}{time in minutes for 1500 m} 
\item{3000m}{time in minutes for 3000 m} 
\item{marathon}{time in minutes for marathon} 
}
}
\source{
Dawkins, B. (1989), "Multivariate Analysis of National Track Records," \emph{The American Statistician, 43}(2), 110-115.
}
\usage{
Track
}
\description{
Data for Exercises 2.97, 5.115, and 9.62
}
\examples{

plot(`200m` ~ `100m`, data = Track)
plot(`400m` ~ `100m`, data = Track)
plot(`400m` ~ `200m`, data = Track)
cor(Track[, 2:8])

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
