% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Hardwood}
\alias{Hardwood}
\title{Tensile strength of Kraft paper for different percentages of hardwood in the
batches of pulp}
\format{A data frame/tibble with 19 observations on two variables
\describe{ 
\item{tensile}{tensile strength of kraft paper (in pounds per square inch)}
\item{hardwood}{percent of hardwood in the batch of pulp that was used to produce the paper} 
}}
\source{
G. Joglekar, et al., "Lack-of-Fit Testing When Replicates Are Not Available,"
\emph{The American Statistician}, 43(3), (1989), 135-143.
}
\usage{
Hardwood
}
\description{
Data for Example 2.18 and Exercise 9.34
}
\examples{

plot(tensile ~ hardwood, data = Hardwood)
model <- lm(tensile ~ hardwood, data = Hardwood)
abline(model, col = "red")
plot(model, which = 1)


}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
