% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Fish}
\alias{Fish}
\title{Length and number of fish caught with small and large mesh codend}
\format{A data frame/tibble with 1534 observations on two variables
\describe{ 
\item{codend}{a character variable with values \code{smallmesh} and \code{largemesh} } 
\item{length}{length of the fish measured in centimeters} 
}}
\source{
R. Millar, \dQuote{Estimating the Size - Selectivity of Fishing Gear by Conditioning
on the Total Catch,} \emph{Journal of the American Statistical Association, 87} (1992), 962 - 968.
}
\usage{
Fish
}
\description{
Data for Exercises 5.83, 5.119, and 7.29
}
\examples{

tapply(Fish$length, Fish$codend, median, na.rm = TRUE)
SIGN.test(Fish$length[Fish$codend == "smallmesh"], conf.level = 0.99)
\dontrun{
dplyr::group_by(Fish, codend) \%>\%
         summarize(MEDIAN = median(length, na.rm = TRUE))
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
