% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrained_covariance_functions.R
\name{constrained_covariance_function}
\alias{constrained_covariance_function}
\title{Construct a constrained covariance matrix from the Euclidean coordinates of the objects}
\usage{
constrained_covariance_function(
  coordinates,
  type,
  hyperparameters,
  linear.combination,
  linear.constraint = 0
)
}
\arguments{
\item{coordinates}{An Nx2 matrix containing the Euclidean coordinates of the nodes.}

\item{type}{The type of covariance function used. One of "sqexp", "ratquad" or "matern". Note: only matern with nu = 5/2 is supported.}

\item{hyperparameters}{A vector containing the covariance function hyperparameters. For the squared exponential and matern, the vector should contain the variance and length scale, for the rational quadratic, the vector should contain the variance, length scale and scaling parameters}

\item{linear.combination}{A matrix which defines the linear combination of the parameter vector lambda = (lambda_1, ..., lambda_N)^T. The linear combination is a vector of coefficients such that linear.combination \%*\% lambda = linear.constraint.}

\item{linear.constraint}{The value the linear constraint takes. Defaults to 0.}
}
\value{
The mean vector and covariance matrix
}
\description{
This function constructs a covariance function from the Euclidean
coordinates of the objects. The covariance function may be
squared exponential, rational quadratic or Matern. It includes a constraint,
where a linear combination of the parameters can be fixed.
}
\examples{
#Generate 10 points and create covariance matrix using Euclidean distance metric
coords <- data.frame("x" = c(0, 1, 2), "y" = c(0, 1, 2)) #generate coordinates
#create covariance matrix using Squared Exponential function and subject to the constraint
#the sum of the deprivation levels is 0.
k <- constrained_covariance_function(coords, "sqexp",
c(1, 5), rep(1, 3), linear.constraint = 0)
}
\seealso{
For more information about covariance functions see \url{https://www.cs.toronto.edu/~duvenaud/cookbook/} or \url{http://gaussianprocess.org/gpml/chapters/RW4.pdf}
}
