% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/true_vals_exp_nocovar.R
\name{true_vals_exp_nocovar}
\alias{true_vals_exp_nocovar}
\title{Adding true values to estimates for models with an exponential endpoint and no consideration of predictors of the intercurrent event}
\usage{
true_vals_exp_nocovar(x, d_params, m_params)
}
\arguments{
\item{x}{Model object as returned by \code{fit_single_exp_nocovar()}.}

\item{d_params}{List of data parameters as used in \code{fit_single_exp_nocovar()}.}

\item{m_params}{List of model parameters as used in \code{fit_single_exp_nocovar()}.}
}
\value{
A summary table with parameter estimates, true values and differences.
}
\description{
Adding true values to estimates for models with an exponential endpoint and no consideration of predictors of the intercurrent event
}
\examples{
d_params_nocovar <- list(
  n = 500L,
  nt = 250L,
  prob_ice = 0.5,
  fu_max = 336L,
  T0T_rate = 0.2,
  T0N_rate = 0.2,
  T1T_rate = 0.15,
  T1N_rate = 0.1
)
dat_single_trial <- sim_dat_one_trial_exp_nocovar(
  n = d_params_nocovar[["n"]], 
  nt = d_params_nocovar[["nt"]],
  prob_ice = d_params_nocovar[["prob_ice"]],
  fu_max = d_params_nocovar[["fu_max"]],  
  T0T_rate = d_params_nocovar[["T0T_rate"]],
  T0N_rate = d_params_nocovar[["T0N_rate"]],
  T1T_rate = d_params_nocovar[["T1T_rate"]],
  T1N_rate = d_params_nocovar[["T1N_rate"]] 
)
m_params_nocovar <- list(
  tg = 48L,
  prior_piT = c(0.5, 0.5),
  prior_0N = c(1.5, 5),
  prior_1N = c(1.5, 5),
  prior_0T = c(1.5, 5),
  prior_1T = c(1.5, 5),
  t_grid =  seq(7, 7 * 48, 7) / 30,
  chains = 2L,
  n_iter = 3000L,
  warmup = 1500L,
  cores = 2L,
  open_progress = FALSE,
  show_messages = TRUE  
)
\donttest{
fit_single <- fit_single_exp_nocovar(
  data = dat_single_trial,
  params = m_params_nocovar,
  summarize_fit = TRUE 
)
print(fit_single) 
tab_obs_truth <- true_vals_exp_nocovar(
  x = fit_single,
  d_params = d_params_nocovar,
  m_params = m_params_nocovar
)
print(tab_obs_truth)
}
}
\seealso{
\code{\link[=true_vals_exp_covar]{true_vals_exp_covar()}}
}
