% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/true_vals_exp_covar.R
\name{true_vals_exp_covar}
\alias{true_vals_exp_covar}
\title{Adding true values to estimates for models with an exponential endpoint and consideration of predictors of the intercurrent event}
\usage{
true_vals_exp_covar(x, d_params, m_params)
}
\arguments{
\item{x}{Model object as returned by \code{fit_single_exp_covar()}.}

\item{d_params}{List of data parameters as used in \code{fit_single_exp_covar()}.}

\item{m_params}{List of model parameters as used in \code{fit_single_exp_covar()}.}
}
\value{
A summary table with parameter estimates, true values and differences.
}
\description{
Adding true values to estimates for models with an exponential endpoint and consideration of predictors of the intercurrent event
}
\examples{
d_params_covar <- list(
  n = 1000,        
  nt = 500,       
  prob_X1 = 0.4, 
  prob_ice_X1 = 0.5, 
  prob_ice_X0 = 0.2,
  fu_max = 48*7,       
  T0T_rate = 0.2,     
  T0N_rate = 0.2,     
  T1T_rate = 0.15,     
  T1N_rate = 0.1
 )
dat_single_trial <- sim_dat_one_trial_exp_covar(
  n = d_params_covar[["n"]], 
  nt = d_params_covar[["nt"]],
  prob_X1 = d_params_covar[["prob_X1"]],
  prob_ice_X1 = d_params_covar[["prob_ice_X1"]],
  prob_ice_X0 = d_params_covar[["prob_ice_X0"]],
  fu_max = d_params_covar[["fu_max"]],  
  T0T_rate = d_params_covar[["T0T_rate"]],
  T0N_rate = d_params_covar[["T0N_rate"]],
  T1T_rate = d_params_covar[["T1T_rate"]],
  T1N_rate = d_params_covar[["T1N_rate"]] 
)
m_params_covar <- list(
  tg = 48,
  p = 2, 
  prior_delta = matrix(
    c(0, 5, 0, 5),
    nrow = 2, byrow = TRUE),
  prior_0N = c(1.5, 5),
  prior_1N = c(1.5, 5),
  prior_0T = c(1.5, 5),
  prior_1T = c(1.5, 5),
  t_grid =  seq(7, 7 * 48, 7) / 30,
  chains = 2,
  n_iter = 3000,
  warmup = 1500,
  cores = 2,
  open_progress = FALSE,
  show_messages = TRUE   
)
\donttest{
fit_single <- fit_single_exp_covar(
  data = dat_single_trial,
  params = m_params_covar,
  summarize_fit = TRUE
)
print(fit_single)
tab_obs_truth <- true_vals_exp_covar(
  x = fit_single,
  d_params = d_params_covar,
  m_params = m_params_covar
)
print(tab_obs_truth)
} 
}
\seealso{
\code{\link[=true_vals_exp_nocovar]{true_vals_exp_nocovar()}}
}
