% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dat_one_trial_exp_covar.R
\name{sim_dat_one_trial_exp_covar}
\alias{sim_dat_one_trial_exp_covar}
\title{Simulate data from a single two-arm trial with an exponentially distributed time-to-event endpoint and one predictor of the intercurrent event}
\usage{
sim_dat_one_trial_exp_covar(
  n,
  nt,
  prob_X1,
  prob_ice_X1,
  prob_ice_X0,
  fu_max,
  T0T_rate,
  T0N_rate,
  T1T_rate,
  T1N_rate
)
}
\arguments{
\item{n}{Positive integer value, number of subjects in the trial.}

\item{nt}{Positive integer value, number of treated subjects.}

\item{prob_X1}{Numeric value on the interval \eqn{(0,1)}, probability of being at high risk of experiencing the intercurrent event of interest when treated (i.e. the event that determines the principal stratum membership).}

\item{prob_ice_X1}{Numeric value on the interval \eqn{(0,1)}, probability of the intercurrent event of interest if treated and at high risk of the intercurrent event.}

\item{prob_ice_X0}{Numeric value on the interval \eqn{(0,1)}, probability of the intercurrent event of interest if treated and not at high risk of the intercurrent event.}

\item{fu_max}{Positive integer value, maximum follow-up time in days (administrative censoring assumed afterwards).}

\item{T0T_rate}{Positive numeric value, monthly event rate in control subjects that would develop the intercurrent event if treated.}

\item{T0N_rate}{Positive numeric value, monthly event rate in control subjects that never develop the intercurrent event.}

\item{T1T_rate}{Positive numeric value, monthly event rate in treated subjects that develop the intercurrent event.}

\item{T1N_rate}{Positive numeric value, monthly event rate in treated subjects that never develop the intercurrent event.}
}
\value{
...
}
\description{
Simulate data from a single two-arm trial with an exponentially distributed time-to-event endpoint and one predictor of the intercurrent event
}
\examples{
d_params_covar <- list(
  n = 1000,        
  nt = 500,       
  prob_X1 = 0.4, 
  prob_ice_X1 = 0.5, 
  prob_ice_X0 = 0.2,
  fu_max = 48*7,       
  T0T_rate = 0.2,     
  T0N_rate = 0.2,     
  T1T_rate = 0.15,     
  T1N_rate = 0.1
 )
dat_single_trial <- sim_dat_one_trial_exp_covar(
  n = d_params_covar[["n"]], 
  nt = d_params_covar[["nt"]],
  prob_X1 = d_params_covar[["prob_X1"]],
  prob_ice_X1 = d_params_covar[["prob_ice_X1"]],
  prob_ice_X0 = d_params_covar[["prob_ice_X0"]],
  fu_max = d_params_covar[["fu_max"]],  
  T0T_rate = d_params_covar[["T0T_rate"]],
  T0N_rate = d_params_covar[["T0N_rate"]],
  T1T_rate = d_params_covar[["T1T_rate"]],
  T1N_rate = d_params_covar[["T1N_rate"]] 
)
dim(dat_single_trial)
head(dat_single_trial)
                  
}
\seealso{
\code{\link[=sim_dat_one_trial_exp_nocovar]{sim_dat_one_trial_exp_nocovar()}}
}
