% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BOSO_multiple_ColdStart.R
\name{BOSO.single}
\alias{BOSO.single}
\title{BOSO.single and associates functions}
\usage{
BOSO.single(
  x,
  y,
  xval,
  yval,
  nlambda = 100,
  lambda.min.ratio = ifelse(nrow(x) < ncol(x), 0.01, 1e-04),
  lambda = NULL,
  intercept = TRUE,
  standardize = TRUE,
  dfmin = 0,
  dfmax = NULL,
  costErrorVal = 1,
  costErrorTrain = 0,
  costVars = 0,
  Threads = 0,
  timeLimit = 1e+75
)
}
\arguments{
\item{x}{Input matrix, of dimension 'n' x 'p'. This is the data from the 
training partition. Its recommended to be class "matrix".}

\item{y}{Response variable for the training dataset. A matrix of one column 
or a vector, with 'n' elements}

\item{xval}{Input matrix, of dimension 'n' x 'p'. This is the data from the 
validation partition. Its recommended to be class "matrix".}

\item{yval}{Response variable for the validation dataset. A matrix of one 
column or a vector, with 'n' elements}

\item{nlambda}{The number of lambda values. Default is 100.}

\item{lambda.min.ratio}{Smallest value for lambda, as a fraction of 
lambda.max, the (data derived) entry value}

\item{lambda}{A user supplied lambda sequence. Typical usage is to have the 
program compute its own lambda sequence based on nlambda and 
lambda.min.ratio. Supplying a value of lambda overrides this. 
WARNING: use with care}

\item{intercept}{Boolean variable to indicate if intercept should be added 
or not. Default is false.}

\item{standardize}{Boolean variable to indicate if data should be scaled 
according to mean(x) mean(y) and sd(x) or not. Default is false.}

\item{dfmin}{Minimum number of variables to be included in the problem. The 
intercept is not included in this number. Default is 0.}

\item{dfmax}{Maximum number of variables to be included in the problem. The 
intercept is not included in this number. Default is min(p,n).}

\item{costErrorVal}{Cost of error of the validation set in the objective 
function. Default is 1. WARNING: use with care, changing this value changes 
the formulation presented in the main article.}

\item{costErrorTrain}{Cost of error of the training set in the objective 
function. Default is 0. WARNING: use with care, changing this value changes 
the formulation presented in the main article.}

\item{costVars}{Cost of new variables in the objective function. Default is 0. 
WARNING: use with care, changing this value changes the formulation 
presented in the main article.}

\item{Threads}{CPLEX parameter, number of cores that cplex is allowed to use.
Default is 0 (automatic).}

\item{timeLimit}{CPLEX parameter, time limit per problem provided to CPLEX.
Default is 1e75 (infinite time).}
}
\description{
Bonjour
}
\details{
Compute the BOSO for ust one block. This function calls ILOG IBM CPLEX with 
cplexAPI to solve the optimization problem
}
\author{
Luis V. Valcarcel
}
