% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_generic.R
\name{plot.BNPdens}
\alias{plot.BNPdens}
\title{Density plot for \code{BNPdens} class}
\usage{
\method{plot}{BNPdens}(x, dimension = c(1, 2), col = "#0037c4",
  show_points = F, show_hist = F, show_clust = F, bin_size = NULL,
  wrap_dim = NULL, xlab = "", ylab = "", band = T,
  conf_level = c(0.025, 0.975), ...)
}
\arguments{
\item{x}{an object of class \code{BNPdens};}

\item{dimension}{if \code{x} has been fitted to multivariate data,
\code{dimensions} specifies the two dimensions for the bivariate contour plot
(if they are equal, a marginal univarite plot is returned);}

\item{col}{the color of the lines;}

\item{show_points}{if \code{TRUE}, the function plots also the observations, default \code{FALSE};}

\item{show_hist}{if \code{TRUE}, and the model is univariate, the function plots also the histogram of the data, default  \code{FALSE};}

\item{show_clust}{if \code{TRUE}, the function plots also the points colored with respect to the estimated partition, default  \code{FALSE};}

\item{bin_size}{if \code{show_hist = TRUE}, it correponds to the size of each bin,
default \code{range(data) / 30};}

\item{wrap_dim}{a two argument vector, if the model is a \code{DDPdensity} estimation result,
it correponds to the number of rows and columns in the plot. Default \code{c(ngroup, 1)};}

\item{xlab}{label of the horizontal axis;}

\item{ylab}{label of the vertical axis;}

\item{band}{if \code{TRUE}, for the univariate case and the DDP case, the plot method returns also the credible bands;}

\item{conf_level}{two values vector, lower and upper levels for the confidence band (default  \code{c(0.025, 0.975)});}

\item{...}{additional arguments to be passed.}
}
\value{
A \code{ggplot2} object.
}
\description{
The function \code{plot.BNPdens} returns different plots for \code{BNPdens}
objects produced by different functions. See details.
}
\details{
If \code{x} is a \code{BNPdens} object generated by \code{PYdensity}, the function returns
the posterior mean univarite or bivariate density plot.
If \code{x} is a \code{BNPdens} object generated by \code{PYregression}, the function returns
the scatterplot of the data colored as in the estimated partition.
If \code{x} is a \code{BNPdens} object generated by \code{DDPdensity}, the function returns
a wrapped plot with one density for each group.
The plots can be tuned in several ways: for univariate densities if \code{show_hist = TRUE},
then the plot shows also the histogram of the data; if \code{show_points = TRUE},
the plot shows also the observed points along the
x-axis; if \code{show_points = TRUE} and \code{show_clust = TRUE}, the points are colored
according to the partition estimated with the \code{partition} function.
For multivariate densities: if  \code{show_points = TRUE},
the plot shows also the scatterplot of the data;
if \code{show_points = TRUE} and  \code{show_clust = TRUE},
the points are colored according to the estimated partition.
}
\examples{
# PYdensity example
data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
grid <- seq(-7, 7, length.out = 50)
est_model <- PYdensity(y = data_toy,
 mcmc = list(niter = 200, nburn = 100, nupd = 100),
 output = list(grid = grid))
class(est_model)
plot(est_model)

# PYregression example
x_toy <- c(rnorm(100, 3, 1), rnorm(100, 3, 1))
y_toy <- c(x_toy[1:100] * 2 + 1, x_toy[101:200] * 6 + 1) + rnorm(200, 0, 1)
grid_x <- c(0, 1, 2, 3, 4, 5)
grid_y <- seq(0, 35, length.out = 50)
est_model <- PYregression(y = y_toy, x = x_toy,
mcmc = list(niter = 200, nburn = 100),
output = list(grid_x = grid_x, grid_y = grid_y))
summary(est_model)
plot(est_model)

# DDPdensity example
data_toy <- c(rnorm(50, -4, 1), rnorm(100, 0, 1), rnorm(50, 4, 1))
group_toy <- c(rep(1,100), rep(2,100))
grid <- seq(-7, 7, length.out = 50)
est_model <- DDPdensity(y = data_toy, group = group_toy,
mcmc = list(niter = 200, nburn = 100, napprox_unif = 50),
output = list(grid = grid))
summary(est_model)
plot(est_model)


}
