% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_generic.R
\name{BNPpart}
\alias{BNPpart}
\title{BNPpart class constructor}
\usage{
BNPpart(partitions = NULL, scores = NULL, psm = NULL)
}
\arguments{
\item{partitions}{a matrix, each row is a visited partition;}

\item{scores}{a vector, each value is the score of a visited partition;}

\item{psm}{a matrix, posterior similarity matrix.}
}
\description{
A constructor for the \code{BNPpart} class. The class \code{BNPpart} is a named list containing
the output of the partition estimation of different methods.
}
\examples{
data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
grid <- seq(-7, 7, length.out = 50)
est_model <- PYdensity(y = data_toy, mcmc = list(niter = 100,
                      nburn = 10, nupd = 100), output = list(grid = grid))
part <- partition(est_model)
class(part)

}
