% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixNRMI2cens.R
\name{plot.NRMI2cens}
\alias{plot.NRMI2cens}
\title{Plot the density estimate and the 95\% credible interval}
\usage{
\method{plot}{NRMI2cens}(x, ...)
}
\arguments{
\item{x}{A fitted object of class MixNRMI2cens}

\item{...}{Further arguments to be passed to generic functions, ignored at the moment}
}
\value{
A graph with the density estimate, the 95\% credible interval
}
\description{
The density estimate is the mean posterior density computed on the data
points. It is not possible to display a histogram for censored data.
}
\examples{

data(salinity)
out <- MixNRMI2cens(salinity$left, salinity$right, Nit = 50)
plot(out)
}
