\name{zlm}
\alias{zlm}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Bayesian Linear Model with Zellner's g}
\description{
  Used to fit the Bayesian normal-conjugate linear model with Zellner's g prior and mean zero coefficent priors. Provides an object similar to the \code{\link{lm}} class.
}
\usage{
zlm(formula, data = NULL, subset = NULL, g = "UIP")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{formula}{ 	an object of class "formula"  (or one that can be coerced to that class), such as a data.frame - cf. \code{\link{lm}} }
  \item{data}{ 	an optional \code{\link{data.frame}}  (or one that can be coerced to that class): cf. \code{\link{lm}} }
  \item{subset}{ an optional vector specifying a subset of observations to be used in the fitting process.}
  \item{g}{ specifies the hyperparameter on Zellner's g-prior for the regression coefficients.\cr 
            \code{g="UIP"} corresponds to \eqn{g=N}, the number of observations (default);
             \code{g="BRIC"} corresponds to the benchmark prior suggested by Fernandez, Ley and Steel (2001), i.e  \eqn{g=max(N, K^2)}, where K is the total number of covariates;\cr
             \code{g="EBL"} estimates a local empirical Bayes g-parameter (as in Liang et al. (2008));\cr
             \code{g="hyper"} takes the 'hyper-g' prior distribution (as in Liang et al., 2008) with the default hyper-parameter \eqn{a=3};
             This hyperparameter can  be adjusted (between \eqn{2<a<=4}) by setting \code{g="hyper=2.9"}, for instance.\cr
             Alternatively, \code{g="hyper=UIP"} sets the prior expected value of the shrinkage factor equal to that of UIP (above), \code{g="hyper=BRIC"} sets it according to BRIC
  }
  
}
\details{
  \code{zlm} estimates the coefficents of the following model \eqn{y = \alpha + X \beta + \epsilon} where \eqn{\epsilon} ~ \eqn{N(0,\sigma^2)} and \eqn{X} is the design matrix\cr
  The priors on the intercept \eqn{\alpha} and the variance \eqn{\sigma} are improper: \eqn{alpha \propto 1}, \eqn{sigma \propto \sigma^{-1}} \cr
  Zellner's g affects the prior on coefficients: \eqn{beta} ~ \eqn{N(0, \sigma^2 g (X'X)^{-1})}. \cr
  Note that the prior mean of coefficients is set to zero by default and cannot be adjusted. Note moreover that \code{zlm} always includes an intercept.
}
\value{
    Returns a list of class \code{zlm} that contains at least the following elements (cf. \code{\link{lm}}):

  \item{coefficients}{a named vector of posterior coefficient expected values}
  \item{residuals}{the residuals, that is response minus fitted values}
  \item{fitted.values}{the fitted mean values}
  \item{rank}{the numeric rank of the fitted linear model}
  \item{df.residual}{the residual degrees of freedom}
  \item{call}{the matched call}
  \item{terms}{the \code{\link{terms}} object used}
  \item{model}{the model frame used}
  \item{coef2moments}{a named vector of coefficient posterior second moments}
  \item{marg.lik}{the log marginal likelihood of the model}
  \item{gprior.info}{a list detailing information on the g-prior, cf. output value \code{gprior.info} in \code{\link{bms}}}
}
\references{
The representation follows 
Fernandez, C. E. Ley and M. Steel (2001): Benchmark priors for Bayesian model averaging. Journal of Econometrics 100(2), 381--427 

See also \url{http://bms.zeugner.eu} for additional help.
}
\author{
Stefan Zeugner
}
\seealso{
The methods \code{\link{summary.zlm}} and \code{\link{predict.lm}} provide additional insights into \code{zlm} output.\cr
The function \code{\link{as.zlm}} extracts a single out model of a \code{bma} object (as e.g. created through\code{\link{bms}}).\cr
Moreover, \code{\link{lm}} for the standard OLS object, \code{\link{bms}} for the application of \code{zlm} in Bayesian model averaging.

Check \url{http://bms.zeugner.eu} for additional help.
}
\examples{

data(datafls)

#simple example
foo = zlm(datafls)
summary(foo)

#example with formula and subset
foo2 = zlm(y~GDP60+LifeExp, data=datafls, subset=2:70) #basic model, omitting three countries
summary(foo2)


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models}