% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MI_LASSO.R
\name{MI_LASSO}
\alias{MI_LASSO}
\title{Multiple-Imputation LASSO (MI-LASSO)}
\usage{
MI_LASSO(
  X,
  Y,
  lamvec = (2^(seq(-1, 4, by = 0.05)))^2/2,
  maxiter = 200,
  eps = 1e-20,
  ncores = 1
)
}
\arguments{
\item{X}{A matrix \code{n×p} or an array \code{D×n×p} of imputed predictor sets.
If a matrix is supplied, it is treated as a single imputation (\code{D = 1}).}

\item{Y}{A vector length \code{n} or a \code{D×n} matrix of outcomes.  If a
vector, it is reused across imputations.}

\item{lamvec}{Numeric vector of penalty parameters \eqn{\lambda} to search. Default \code{(2^(seq(-1,4,by=0.05)))^2/2}.}

\item{maxiter}{Integer; maximum number of ridge–update iterations per \code{lambda}.
Default \code{200}.}

\item{eps}{Numeric; convergence tolerance on coefficient change. Default \code{1e-20}.}

\item{ncores}{Integer; number of cores for parallelizing over \code{lamvec}.
Default \code{1}.}
}
\value{
If \code{length(lamvec) > 1}, a list with elements:
\describe{
\item{\code{best}}{List for the \eqn{lambda} with minimal BIC containing:
\code{coefficients} (\code{(p+1)×D} intercept + slopes),
\code{bic} (BIC scalar),
\code{varsel} (logical length-\code{p} vector of selected predictors),
\code{lambda} (the chosen penalty).}
\item{\code{lambda_path}}{\code{length(lamvec)×2} matrix of each
\code{lambda} and its corresponding BIC.}
}
If \code{length(lamvec) == 1}, returns a single list (as above) for that
penalty.
}
\description{
Fit a LASSO-like penalty across \code{D} multiply-imputed datasets by
iteratively reweighted ridge regressions (Equation (4) of the manuscript).
For each tuning parameter in \code{lamvec}, it returns the pooled
coefficient estimates, the BIC, and the selected variables.
}
\examples{
sim <- sim_A(n = 100, p = 20, type = "MAR", SNP = 1.5, low_missing = TRUE, n_imp = 5, seed = 123)
X <- sim$data_MI$X
Y <- sim$data_MI$Y
fit <- MI_LASSO(X, Y, lamvec = c(0.1))
}
